/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.missiles;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.vehicle.missiles.Ammo;
import net.shadowmage.ancientwarfare.vehicle.missiles.MissileBase;

public class AmmoExplosiveShot
extends Ammo {
    private boolean bigExplosion;

    public AmmoExplosiveShot(int weight, boolean bigExplosion) {
        super("ammo_explosive_shot_" + weight + (bigExplosion ? "_big" : ""));
        this.ammoWeight = weight;
        this.bigExplosion = bigExplosion;
        this.entityDamage = weight;
        this.vehicleDamage = weight;
        float scaleFactor = (float)weight + 45.0f;
        this.renderScale = (float)weight / scaleFactor * 2.0f;
        this.configName = bigExplosion ? "high_explosive_" + weight : "explosive_" + weight;
        this.modelTexture = new ResourceLocation("ancientwarfare", "textures/model/vehicle/ammo/ammo_stone_shot.png");
    }

    @Override
    public void onImpactWorld(World world, float x, float y, float z, MissileBase missile, RayTraceResult hit) {
        if (!world.field_72995_K) {
            Vec3i dirVec = hit.field_178784_b.func_176730_m();
            Vec3d hitVec = hit.field_72307_f.func_72441_c((double)dirVec.func_177958_n() * 0.2, (double)dirVec.func_177956_o() * 0.2, (double)dirVec.func_177952_p() * 0.2);
            this.explode(world, (float)hitVec.field_72450_a, (float)hitVec.field_72448_b, (float)hitVec.field_72449_c, missile);
        }
    }

    @Override
    public void onImpactEntity(World world, Entity ent, float x, float y, float z, MissileBase missile) {
        if (!world.field_72995_K) {
            this.explode(world, x, y, z, missile);
        }
    }

    private void explode(World world, float x, float y, float z, MissileBase missile) {
        float maxPower = this.bigExplosion ? 7.0f : 3.5f;
        float powerPercent = this.ammoWeight / 45.0f;
        float power = maxPower * powerPercent;
        this.createExplosion(world, missile, x, y, z, power);
    }
}

