/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.missiles;

import net.minecraft.entity.Entity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.vehicle.missiles.Ammo;
import net.shadowmage.ancientwarfare.vehicle.missiles.MissileBase;
import net.shadowmage.ancientwarfare.vehicle.registry.AmmoRegistry;

public class AmmoClusterShot
extends Ammo {
    public AmmoClusterShot(int weight) {
        super("ammo_cluster_shot_" + weight);
        this.ammoWeight = weight;
        float scaleFactor = (float)weight + 45.0f;
        this.renderScale = (float)weight / scaleFactor * 2.0f;
        this.configName = "cluster_shot_" + weight;
        this.modelTexture = new ResourceLocation("ancientwarfare", "textures/model/vehicle/ammo/ammo_stone_shot.png");
        this.entityDamage = 5;
        this.vehicleDamage = 5;
    }

    @Override
    public void onImpactWorld(World world, float x, float y, float z, MissileBase missile, RayTraceResult hit) {
        if (!world.field_72995_K) {
            this.spawnGroundBurst(world, hit, 10.0f, AmmoRegistry.ammoBallShot, (int)this.ammoWeight, 35.0f, missile.shooterLiving);
        }
    }

    @Override
    public void onImpactEntity(World world, Entity ent, float x, float y, float z, MissileBase missile) {
        if (!world.field_72995_K) {
            this.spawnAirBurst(world, (float)ent.field_70165_t, (float)ent.field_70163_u + ent.field_70131_O, (float)ent.field_70161_v, 10.0f, AmmoRegistry.ammoBallShot, (int)this.ammoWeight, missile.shooterLiving);
        }
    }
}

