/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.item;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.render.item.IItemRenderer;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.vehicle.AncientWarfareVehicles;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.IVehicleType;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleType;
import net.shadowmage.ancientwarfare.vehicle.item.ItemBaseVehicle;
import net.shadowmage.ancientwarfare.vehicle.render.RenderItemSpawner;

public class ItemSpawner
extends ItemBaseVehicle {
    private static final String LEVEL_TAG = "level";
    private static final String HEALTH_TAG = "health";
    private static final String SPAWN_DATA_TAG = "spawnData";

    public ItemSpawner() {
        super("spawner");
        this.func_77627_a(true);
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        if (stack.func_190926_b()) {
            return new ActionResult(EnumActionResult.FAIL, (Object)stack);
        }
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(SPAWN_DATA_TAG)) {
            if (this.rayTraceAndSpawnVehicle(world, player, hand, stack)) {
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        AncientWarfareVehicles.LOG.error("Vehicle spawner item was missing NBT data, something may have corrupted this item");
        return new ActionResult(EnumActionResult.FAIL, (Object)stack);
    }

    private boolean rayTraceAndSpawnVehicle(World world, EntityPlayer player, EnumHand hand, ItemStack stack) {
        RayTraceResult rayTrace;
        NBTTagCompound tag = stack.func_77978_p().func_74775_l(SPAWN_DATA_TAG);
        int level = tag.func_74762_e(LEVEL_TAG);
        Optional<VehicleBase> v = VehicleType.getVehicleForType(world, stack.func_77952_i(), level);
        if (!v.isPresent()) {
            return true;
        }
        VehicleBase vehicle = v.get();
        if (tag.func_74764_b(HEALTH_TAG)) {
            vehicle.setHealth(tag.func_74760_g(HEALTH_TAG));
        }
        if ((rayTrace = this.func_77621_a(world, player, true)) == null || rayTrace.field_72313_a != RayTraceResult.Type.BLOCK) {
            return true;
        }
        this.spawnVehicle(world, player, vehicle, rayTrace);
        this.updateSpawnerStackCount(player, hand, stack);
        return false;
    }

    private void updateSpawnerStackCount(EntityPlayer player, EnumHand hand, ItemStack stack) {
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
            if (stack.func_190916_E() <= 0) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
        }
    }

    private void spawnVehicle(World world, EntityPlayer player, VehicleBase vehicle, RayTraceResult rayTrace) {
        Vec3d hitVec = rayTrace.field_72307_f;
        if (rayTrace.field_178784_b.func_176740_k().func_176722_c()) {
            Vec3i dirVec = rayTrace.field_178784_b.func_176730_m();
            float halfWidth = vehicle.field_70130_N / 2.0f;
            hitVec = hitVec.func_72441_c((double)((float)dirVec.func_177958_n() * halfWidth), 0.0, (double)((float)dirVec.func_177952_p() * halfWidth));
        }
        vehicle.func_70107_b(hitVec.field_72450_a, hitVec.field_72448_b, hitVec.field_72449_c);
        vehicle.field_70126_B = vehicle.field_70177_z = -player.field_70177_z + 180.0f;
        vehicle.localTurretRotation = vehicle.localTurretRotationHome = vehicle.field_70177_z;
        vehicle.localTurretDestRot = vehicle.localTurretRotationHome;
        if (AWVehicleStatics.useVehicleSetupTime) {
            vehicle.setSetupState(true, 100);
        }
        world.func_72838_d((Entity)vehicle);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, world, tooltip, flagIn);
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(SPAWN_DATA_TAG)) {
            Optional<VehicleBase> v;
            NBTTagCompound tag = stack.func_77978_p().func_74775_l(SPAWN_DATA_TAG);
            int level = tag.func_74762_e(LEVEL_TAG);
            tooltip.add("Material Level: " + level);
            if (tag.func_74764_b(HEALTH_TAG)) {
                tooltip.add("Vehicle Health: " + tag.func_74760_g(HEALTH_TAG));
            }
            if (!(v = VehicleType.getVehicleForType(world, stack.func_77952_i(), level)).isPresent()) {
                return;
            }
            tooltip.addAll(v.get().vehicleType.getDisplayTooltip().stream().map(x$0 -> I18n.func_135052_a((String)x$0, (Object[])new Object[0])).collect(Collectors.toSet()));
        }
    }

    public String func_77667_c(ItemStack stack) {
        IVehicleType vehicle = VehicleType.vehicleTypes[stack.func_77952_i()];
        return vehicle == null ? "" : vehicle.getDisplayName();
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        items.addAll(VehicleType.getCreativeDisplayItems());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        ModelRegistryHelper.registerItemRenderer((Item)this, (IItemRenderer)new RenderItemSpawner());
    }
}

