/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.gui.elements;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.missiles.IAmmo;
import net.shadowmage.ancientwarfare.vehicle.registry.AmmoRegistry;

@SideOnly(value=Side.CLIENT)
public class ButtonAmmo
extends Button {
    IAmmo ammo;
    ItemStack stack;
    VehicleBase vehicle;
    protected static RenderItem itemRenderer = Minecraft.func_71410_x().func_175599_af();

    public ButtonAmmo(int topLeftX, int topLeftY, int width, int height, IAmmo ammo, VehicleBase vehicle) {
        super(topLeftX, topLeftY, width, height, "");
        this.ammo = ammo;
        this.stack = new ItemStack((Item)AmmoRegistry.getItemForAmmo(ammo));
        this.vehicle = vehicle;
        if (ammo != null) {
            this.setText(I18n.func_135052_a((String)("item." + ammo.getRegistryName().func_110623_a() + ".name"), (Object[])new Object[0]));
        }
    }

    @Override
    protected void onPressed() {
        this.vehicle.ammoHelper.handleClientAmmoSelection(this.ammo.getRegistryName());
    }

    @Override
    public void render(int mouseX, int mouseY, float partialTick) {
        super.render(mouseX, mouseY, partialTick);
        if (this.visible && this.ammo != null) {
            String quantity = String.valueOf(this.vehicle.ammoHelper.getCountOf(this.ammo));
            itemRenderer.func_175042_a(this.stack, this.renderX + 3, this.renderY + 3);
            int quantityRenderX = this.renderX + this.width - 10 - Minecraft.func_71410_x().field_71466_p.func_78256_a(quantity);
            Minecraft.func_71410_x().field_71466_p.func_175063_a(String.valueOf(quantity), (float)quantityRenderX, (float)(this.renderY + this.textY), -1);
        }
    }
}

