/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.entity.types;

import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.vehicle.config.AWVehicleStatics;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.entity.materials.VehicleMaterial;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleType;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleFiringVarsHelper;
import net.shadowmage.ancientwarfare.vehicle.registry.AmmoRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.ArmorRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.UpgradeRegistry;

public class VehicleTypeCannon
extends VehicleType {
    public VehicleTypeCannon(int typeNum) {
        super(typeNum);
        this.configName = "cannon_base";
        this.vehicleMaterial = VehicleMaterial.materialIron;
        this.materialCount = 5;
        this.maxMissileWeight = 10.0f;
        this.validAmmoTypes.add(AmmoRegistry.ammoIronShot5);
        this.validAmmoTypes.add(AmmoRegistry.ammoIronShot10);
        this.validAmmoTypes.add(AmmoRegistry.ammoGrapeShot5);
        this.validAmmoTypes.add(AmmoRegistry.ammoGrapeShot10);
        this.validAmmoTypes.add(AmmoRegistry.ammoCanisterShot5);
        this.validAmmoTypes.add(AmmoRegistry.ammoCanisterShot10);
        if (AWVehicleStatics.oversizeAmmoEnabled) {
            this.validAmmoTypes.add(AmmoRegistry.ammoIronShot15);
            this.validAmmoTypes.add(AmmoRegistry.ammoIronShot25);
            this.validAmmoTypes.add(AmmoRegistry.ammoGrapeShot15);
            this.validAmmoTypes.add(AmmoRegistry.ammoGrapeShot25);
            this.validAmmoTypes.add(AmmoRegistry.ammoCanisterShot15);
            this.validAmmoTypes.add(AmmoRegistry.ammoCanisterShot25);
        }
        this.ammoBySoldierRank.put(0, AmmoRegistry.ammoIronShot5);
        this.ammoBySoldierRank.put(1, AmmoRegistry.ammoIronShot5);
        this.ammoBySoldierRank.put(2, AmmoRegistry.ammoIronShot5);
        this.validUpgrades.add(UpgradeRegistry.pitchDownUpgrade);
        this.validUpgrades.add(UpgradeRegistry.pitchUpUpgrade);
        this.validUpgrades.add(UpgradeRegistry.pitchExtUpgrade);
        this.validUpgrades.add(UpgradeRegistry.powerUpgrade);
        this.validUpgrades.add(UpgradeRegistry.reloadUpgrade);
        this.validUpgrades.add(UpgradeRegistry.aimUpgrade);
        this.validArmors.add(ArmorRegistry.armorStone);
        this.validArmors.add(ArmorRegistry.armorIron);
        this.validArmors.add(ArmorRegistry.armorObsidian);
        this.turretVerticalOffset = 0.71875f;
        this.storageBaySize = 0;
        this.accuracy = 0.98f;
        this.drivable = true;
        this.baseForwardSpeed = 0.0f;
        this.baseStrafeSpeed = 0.5f;
        this.basePitchMax = 15.0f;
        this.basePitchMin = -15.0f;
        this.mountable = true;
        this.combatEngine = true;
        this.pitchAdjustable = true;
        this.powerAdjustable = false;
        this.yawAdjustable = false;
        this.baseMissileVelocityMax = 42.0f;
        this.width = 2.0f;
        this.height = 2.0f;
        this.armorBaySize = 3;
        this.upgradeBaySize = 3;
        this.ammoBaySize = 6;
    }

    @Override
    public ResourceLocation getTextureForMaterialLevel(int level) {
        switch (level) {
            case 0: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/cannon_1.png");
            }
            case 1: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/cannon_2.png");
            }
            case 2: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/cannon_3.png");
            }
            case 3: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/cannon_4.png");
            }
            case 4: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/cannon_5.png");
            }
        }
        return new ResourceLocation("ancientwarfare", "textures/model/vehicle/cannon_1.png");
    }

    @Override
    public VehicleFiringVarsHelper getFiringVarsHelper(VehicleBase veh) {
        return new CannonVarHelper(veh);
    }

    public class CannonVarHelper
    extends VehicleFiringVarsHelper {
        private int firingTicks;

        private CannonVarHelper(VehicleBase vehicle) {
            super(vehicle);
            this.firingTicks = 0;
        }

        public NBTTagCompound serializeNBT() {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("fT", this.firingTicks);
            return tag;
        }

        public void deserializeNBT(NBTTagCompound tag) {
        }

        @Override
        public void onFiringUpdate() {
            if (this.firingTicks == 0 && !this.vehicle.field_70170_p.field_72995_K) {
                this.vehicle.func_184185_a(SoundEvents.field_187631_bo, 0.5f, 0.25f);
                this.vehicle.func_184185_a(SoundEvents.field_187904_gd, 1.0f, 0.5f);
            }
            ++this.firingTicks;
            if (this.vehicle.field_70170_p.field_72995_K) {
                this.vehicle.field_70170_p.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, this.vehicle.field_70165_t, this.vehicle.field_70163_u + 1.2, this.vehicle.field_70161_v, 0.0, 0.05, 0.0, new int[0]);
            }
            if (this.firingTicks > 10) {
                if (!this.vehicle.field_70170_p.field_72995_K) {
                    this.vehicle.func_184185_a(SoundEvents.field_187539_bB, 1.0f, 1.0f);
                }
                this.vehicle.firingHelper.startLaunching();
                this.firingTicks = 0;
            }
        }

        @Override
        public void onReloadUpdate() {
        }

        @Override
        public void onLaunchingUpdate() {
            this.vehicle.firingHelper.spawnMissile(0.0f, 0.0f, 0.0f);
            this.vehicle.firingHelper.setFinishedLaunching();
        }

        @Override
        public void onReloadingFinished() {
            this.firingTicks = 0;
        }

        @Override
        public float getVar1() {
            return 0.0f;
        }

        @Override
        public float getVar2() {
            return 0.0f;
        }

        @Override
        public float getVar3() {
            return 0.0f;
        }

        @Override
        public float getVar4() {
            return 0.0f;
        }

        @Override
        public float getVar5() {
            return 0.0f;
        }

        @Override
        public float getVar6() {
            return 0.0f;
        }

        @Override
        public float getVar7() {
            return 0.0f;
        }

        @Override
        public float getVar8() {
            return 0.0f;
        }
    }
}

