/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.entity.types;

import net.minecraft.init.SoundEvents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleMovementType;
import net.shadowmage.ancientwarfare.vehicle.entity.materials.VehicleMaterial;
import net.shadowmage.ancientwarfare.vehicle.entity.types.VehicleType;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleFiringVarsHelper;
import net.shadowmage.ancientwarfare.vehicle.registry.AmmoRegistry;
import net.shadowmage.ancientwarfare.vehicle.registry.UpgradeRegistry;

public class VehicleTypeAirInterceptor
extends VehicleType {
    public VehicleTypeAirInterceptor(int typeNum) {
        super(typeNum);
        this.configName = "aircraft_interceptor";
        this.vehicleMaterial = VehicleMaterial.materialWood;
        this.materialCount = 4;
        this.movementType = VehicleMovementType.AIR1;
        this.maxMissileWeight = 10.0f;
        this.validAmmoTypes.add(AmmoRegistry.ammoPebbleShot10);
        this.validAmmoTypes.add(AmmoRegistry.ammoArrow);
        this.validAmmoTypes.add(AmmoRegistry.ammoArrowFlame);
        this.validAmmoTypes.add(AmmoRegistry.ammoArrowIron);
        this.validAmmoTypes.add(AmmoRegistry.ammoArrowIronFlame);
        this.validAmmoTypes.add(AmmoRegistry.ammoRocket);
        this.validAmmoTypes.add(AmmoRegistry.ammoHwachaRocketFlame);
        this.validAmmoTypes.add(AmmoRegistry.ammoHwachaRocketExplosive);
        this.validAmmoTypes.add(AmmoRegistry.ammoHwachaRocketAirburst);
        this.ammoBySoldierRank.put(0, AmmoRegistry.ammoArrow);
        this.ammoBySoldierRank.put(1, AmmoRegistry.ammoArrowFlame);
        this.ammoBySoldierRank.put(2, AmmoRegistry.ammoArrowIronFlame);
        this.validUpgrades.add(UpgradeRegistry.speedUpgrade);
        this.validUpgrades.add(UpgradeRegistry.reloadUpgrade);
        this.validUpgrades.add(UpgradeRegistry.powerUpgrade);
        this.validUpgrades.add(UpgradeRegistry.aimUpgrade);
        this.armorBaySize = 0;
        this.upgradeBaySize = 6;
        this.ammoBaySize = 2;
        this.storageBaySize = 0;
        this.baseHealth = 50.0f;
        this.width = 2.7f;
        this.height = 1.4f;
        this.baseStrafeSpeed = 2.0f;
        this.baseForwardSpeed = 1.25f;
        this.turretForwardsOffset = 0.0f;
        this.turretVerticalOffset = 0.0f;
        this.missileVerticalOffset = 0.25f;
        this.accuracy = 0.94f;
        this.basePitchMax = 0.0f;
        this.basePitchMin = 0.0f;
        this.baseMissileVelocityMax = 50.0f;
        this.riderForwardsOffset = -0.4375f;
        this.riderVerticalOffset = 0.6f;
        this.riderSits = true;
        this.mountable = true;
        this.drivable = true;
        this.combatEngine = true;
        this.pilotableBySoldiers = false;
        this.pitchAdjustable = true;
        this.powerAdjustable = false;
        this.yawAdjustable = false;
        this.turretRotationMax = 0.0f;
        this.displayName = "item.vehicleSpawner.22";
        this.displayTooltip.add("item.vehicleSpawner.tooltip.gunpowder");
        this.displayTooltip.add("item.vehicleSpawner.tooltip.air");
        this.displayTooltip.add("item.vehicleSpawner.tooltip.noturret");
        this.enabled = false;
    }

    @Override
    public ResourceLocation getTextureForMaterialLevel(int level) {
        switch (level) {
            case 0: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/airplane_1.png");
            }
            case 1: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/airplane_2.png");
            }
            case 2: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/airplane_3.png");
            }
            case 3: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/airplane_4.png");
            }
            case 4: {
                return new ResourceLocation("ancientwarfare", "textures/model/vehicle/airplane_5.png");
            }
        }
        return new ResourceLocation("ancientwarfare", "textures/model/vehicle/airplane_1.png");
    }

    @Override
    public VehicleFiringVarsHelper getFiringVarsHelper(VehicleBase veh) {
        return new AircraftVarsHelper(veh);
    }

    public class AircraftVarsHelper
    extends VehicleFiringVarsHelper {
        private int missileFired;
        private int maxMissiles;
        private int delayTick;

        private AircraftVarsHelper(VehicleBase vehicle) {
            super(vehicle);
            this.missileFired = 0;
            this.maxMissiles = 0;
            this.delayTick = 0;
        }

        public NBTTagCompound serializeNBT() {
            return new NBTTagCompound();
        }

        public void deserializeNBT(NBTTagCompound tag) {
        }

        @Override
        public void onFiringUpdate() {
            this.maxMissiles = this.vehicle.firingHelper.getMissileLaunchCount();
            this.vehicle.firingHelper.startLaunching();
        }

        @Override
        public void onReloadUpdate() {
        }

        @Override
        public void onLaunchingUpdate() {
            ++this.delayTick;
            if (this.delayTick >= 2) {
                this.delayTick = 0;
                if (!this.vehicle.field_70170_p.field_72995_K && this.vehicle.ammoHelper.getCurrentAmmoCount() > 0) {
                    this.vehicle.func_184185_a(SoundEvents.field_187631_bo, 1.0f, 0.5f);
                }
                this.vehicle.firingHelper.spawnMissile(0.0f, 0.0f, 0.0f);
                ++this.missileFired;
                if (this.missileFired >= this.maxMissiles) {
                    this.vehicle.firingHelper.setFinishedLaunching();
                }
            }
        }

        @Override
        public void onReloadingFinished() {
            this.missileFired = 0;
            this.delayTick = 0;
        }

        @Override
        public float getVar1() {
            return 0.0f;
        }

        @Override
        public float getVar2() {
            return 0.0f;
        }

        @Override
        public float getVar3() {
            return 0.0f;
        }

        @Override
        public float getVar4() {
            return 0.0f;
        }

        @Override
        public float getVar5() {
            return 0.0f;
        }

        @Override
        public float getVar6() {
            return 0.0f;
        }

        @Override
        public float getVar7() {
            return 0.0f;
        }

        @Override
        public float getVar8() {
            return 0.0f;
        }
    }
}

