/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.vehicle.VehicleVarHelpers;

import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;
import net.shadowmage.ancientwarfare.vehicle.helpers.VehicleFiringVarsHelper;

public class BallistaVarHelper
extends VehicleFiringVarsHelper {
    public float crankAngle = 0.0f;
    public float crankSpeed = 0.0f;
    public float bowAngle = 67.5f;
    public float bowSpeed = 0.0f;
    public float stringAngle = this.getStringAngle(this.bowAngle);
    public float stringSpeed = 0.0f;
    public float triggerAngle = 0.0f;

    public BallistaVarHelper(VehicleBase vehicle) {
        super(vehicle);
    }

    @Override
    public void onFiringUpdate() {
        this.vehicle.firingHelper.startLaunching();
        this.vehicle.firingHelper.spawnMissile(0.0f, 0.0f, 0.0f);
        this.triggerAngle = 0.0f;
    }

    @Override
    public void onReloadUpdate() {
        float prevAngle = this.bowAngle;
        this.bowAngle += 37.5f / (float)this.vehicle.currentReloadTicks;
        if (this.bowAngle >= 67.5f) {
            this.bowAngle = 67.5f;
            this.triggerAngle = -70.0f;
        }
        this.bowSpeed = this.bowAngle - prevAngle;
        prevAngle = this.stringAngle;
        this.stringAngle = this.getStringAngle(this.bowAngle);
        this.stringSpeed = this.stringAngle - prevAngle;
        this.crankAngle -= 4.0f;
        this.crankSpeed = -4.0f;
    }

    @Override
    public void onLaunchingUpdate() {
        float prevAngle = this.bowAngle;
        this.bowAngle = (float)((double)this.bowAngle - 7.5);
        if (this.bowAngle < 30.0f) {
            this.bowAngle = 30.0f;
            this.vehicle.firingHelper.setFinishedLaunching();
        }
        this.bowSpeed = this.bowAngle - prevAngle;
        prevAngle = this.stringAngle;
        this.stringAngle = this.getStringAngle(this.bowAngle);
        this.stringSpeed = this.stringAngle - prevAngle;
    }

    @Override
    public void onReloadingFinished() {
        this.bowAngle = 67.5f;
        this.stringAngle = this.getStringAngle(this.bowAngle);
        this.bowSpeed = 0.0f;
        this.stringSpeed = 0.0f;
        this.crankSpeed = 0.0f;
        this.triggerAngle = -70.0f;
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74776_a("cA", this.crankAngle);
        tag.func_74776_a("cS", this.crankSpeed);
        tag.func_74776_a("bA", this.bowAngle);
        tag.func_74776_a("bS", this.bowSpeed);
        tag.func_74776_a("sA", this.stringAngle);
        tag.func_74776_a("sS", this.stringSpeed);
        tag.func_74776_a("tA", this.triggerAngle);
        return tag;
    }

    public float getStringAngle(float bowAngle) {
        float percentTravel = (bowAngle - 30.0f) / 37.5f;
        float adj = percentTravel * 1.305f;
        return -30.0f - adj * bowAngle;
    }

    public void deserializeNBT(NBTTagCompound tag) {
        this.crankAngle = tag.func_74760_g("cA");
        this.crankSpeed = tag.func_74760_g("cS");
        this.bowAngle = tag.func_74760_g("bA");
        this.bowSpeed = tag.func_74760_g("bS");
        this.stringAngle = tag.func_74760_g("sA");
        this.stringSpeed = tag.func_74760_g("sS");
        this.triggerAngle = tag.func_74760_g("tA");
    }

    @Override
    public float getVar1() {
        return this.crankAngle;
    }

    @Override
    public float getVar2() {
        return this.crankSpeed;
    }

    @Override
    public float getVar3() {
        return this.bowAngle;
    }

    @Override
    public float getVar4() {
        return this.bowSpeed;
    }

    @Override
    public float getVar5() {
        return this.stringAngle;
    }

    @Override
    public float getVar6() {
        return this.stringSpeed;
    }

    @Override
    public float getVar7() {
        return this.triggerAngle;
    }

    @Override
    public float getVar8() {
        return 0.0f;
    }
}

