/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.worldgen;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.IChunkGenerator;
import net.minecraftforge.fml.common.IWorldGenerator;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureMap;
import net.shadowmage.ancientwarfare.structure.gamedata.TownMap;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.WorldGenStructureManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilderWorldGen;
import net.shadowmage.ancientwarfare.structure.worldgen.StructureEntry;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldGenTickHandler;

public class WorldStructureGenerator
implements IWorldGenerator {
    public static final WorldStructureGenerator INSTANCE = new WorldStructureGenerator();
    private static final int MAX_DISTANCE_WITHIN_CLUSTER = 150;
    private final Random rng = new Random();

    private WorldStructureGenerator() {
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkGenerator chunkGenerator, IChunkProvider chunkProvider) {
        BlockPos cc = world.func_175694_M();
        double distSq = cc.func_177954_c((double)chunkX * 16.0, (double)cc.func_177956_o(), (double)chunkZ * 16.0);
        if (AWStructureStatics.withinProtectionRange(distSq)) {
            return;
        }
        if (this.rng.nextFloat() < AWStructureStatics.randomGenerationChance) {
            WorldGenTickHandler.INSTANCE.addChunkForGeneration(world, chunkX, chunkZ);
        }
    }

    void generateAt(int chunkX, int chunkZ, World world) {
        if (world == null) {
            return;
        }
        long t1 = System.currentTimeMillis();
        long seed = (long)chunkX << 32 | (long)chunkZ & 0xFFFFFFFFL;
        this.rng.setSeed(seed);
        int x = chunkX * 16 + this.rng.nextInt(16);
        int z = chunkZ * 16 + this.rng.nextInt(16);
        int y = WorldStructureGenerator.getTargetY(world, x, z, false) + 1;
        if (y <= 0) {
            return;
        }
        EnumFacing face = EnumFacing.field_176754_o[this.rng.nextInt(4)];
        world.field_72984_F.func_76320_a("AWTemplateSelection");
        StructureTemplate template = WorldGenStructureManager.INSTANCE.selectTemplateForGeneration(world, this.rng, x, y, z, face);
        world.field_72984_F.func_76319_b();
        AncientWarfareStructure.LOG.debug("Template selection took: " + (System.currentTimeMillis() - t1) + " ms.");
        if (template == null) {
            return;
        }
        StructureMap map = AWGameData.INSTANCE.getData(world, StructureMap.class);
        if (map == null) {
            return;
        }
        world.field_72984_F.func_76320_a("AWTemplateGeneration");
        if (this.attemptStructureGenerationAt(world, new BlockPos(x, y, z), face, template, map)) {
            AncientWarfareStructure.LOG.info(String.format("Generated structure: %s at %s, %s, %s, time: %sms", template.name, x, y, z, System.currentTimeMillis() - t1));
        }
        world.field_72984_F.func_76319_b();
    }

    public static int getTargetY(World world, int x, int z, boolean skipWater) {
        for (int y = world.func_72940_L(); y > 0; --y) {
            IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
            Block block = state.func_177230_c();
            if (AWStructureStatics.isSkippable(state) || skipWater && (block == Blocks.field_150355_j || block == Blocks.field_150358_i)) continue;
            return y;
        }
        return -1;
    }

    public static void sprinkleSnow(World world, StructureBB bb, int border) {
        BlockPos p1 = bb.min.func_177982_a(-border, 0, -border);
        BlockPos p2 = bb.max.func_177982_a(border, 0, border);
        for (int x = p1.func_177958_n(); x <= p2.func_177958_n(); ++x) {
            for (int z = p1.func_177952_p(); z <= p2.func_177952_p(); ++z) {
                IBlockState state;
                Block block;
                int y = world.func_175725_q(new BlockPos(x, 1, z)).func_177956_o() - 1;
                BlockPos pos = new BlockPos(x, y, z);
                if (p2.func_177956_o() < y || y <= 0 || !world.canSnowAtBody(pos.func_177984_a(), true) || (block = (state = world.func_180495_p(pos)).func_177230_c()) == Blocks.field_150350_a || state.func_193401_d((IBlockAccess)world, pos, EnumFacing.UP) != BlockFaceShape.SOLID) continue;
                world.func_175656_a(pos.func_177984_a(), Blocks.field_150431_aC.func_176223_P());
            }
        }
    }

    public static int getStepNumber(int x, int z, int minX, int maxX, int minZ, int maxZ) {
        int steps = 0;
        if (x < minX - 1) {
            steps += minX - 1 - x;
        } else if (x > maxX + 1) {
            steps += x - (maxX + 1);
        }
        if (z < minZ - 1) {
            steps += minZ - 1 - z;
        } else if (z > maxZ + 1) {
            steps += z - (maxZ + 1);
        }
        return steps;
    }

    public final boolean attemptStructureGenerationAt(World world, BlockPos pos, EnumFacing face, StructureTemplate template, StructureMap map) {
        int zs;
        long t1 = System.currentTimeMillis();
        int prevY = pos.func_177956_o();
        StructureBB bb = new StructureBB(pos, face, template.getSize(), template.getOffset());
        int y = template.getValidationSettings().getAdjustedSpawnY(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), face, template, bb);
        pos = new BlockPos(pos.func_177958_n(), y, pos.func_177952_p());
        bb.min = bb.min.func_177981_b(y - prevY);
        bb.max = bb.max.func_177981_b(y - prevY);
        int xs = bb.getXSize();
        int size = (xs > (zs = bb.getZSize()) ? xs : zs) / 16 + 3;
        if (map != null && !this.checkOtherStructureCrossAndCloseness(world, pos, map, bb, size, template.getValidationSettings().getBorderSize())) {
            return true;
        }
        TownMap townMap = AWGameData.INSTANCE.getPerWorldData(world, TownMap.class);
        if (townMap != null && townMap.intersectsWithTown(bb)) {
            AncientWarfareStructure.LOG.debug("Skipping structure generation: " + template.name + " at: " + bb + " for intersection with existing town");
            return false;
        }
        if (template.getValidationSettings().validatePlacement(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), face, template, bb)) {
            AncientWarfareStructure.LOG.debug("Validation took: " + (System.currentTimeMillis() - t1) + " ms");
            this.generateStructureAt(world, pos, face, template, map);
            return true;
        }
        return false;
    }

    private boolean checkOtherStructureCrossAndCloseness(World world, BlockPos pos, StructureMap map, StructureBB bb, int size, int borderSize) {
        Collection<StructureEntry> bbCheckList = map.getEntriesNear(world, pos.func_177958_n(), pos.func_177952_p(), size, true, new ArrayList<StructureEntry>());
        double maxDistance = 0.0;
        StructureBB bbWithBorder = new StructureBB(bb.min, bb.max).expand(borderSize, 0, borderSize);
        for (StructureEntry entry : bbCheckList) {
            if (bbWithBorder.crossWith(entry.getBB())) {
                return false;
            }
            double distance = bb.getDistanceTo(entry.getBB());
            if (!(distance < 150.0) || !(distance > maxDistance)) continue;
            maxDistance = distance;
        }
        return !(maxDistance > 30.0) || !((double)world.field_73012_v.nextFloat() * (150.0 - maxDistance) > 30.0);
    }

    private void generateStructureAt(World world, BlockPos pos, EnumFacing face, StructureTemplate template, StructureMap map) {
        if (map != null) {
            map.setGeneratedAt(world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), face, new StructureEntry(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), face, template), template.getValidationSettings().isUnique());
        }
        WorldGenTickHandler.INSTANCE.addStructureForGeneration(new StructureBuilderWorldGen(world, template, face, pos));
    }
}

