/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.worldgen;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;

public class StructureEntry {
    public String name;
    private int value;
    public final StructureBB bb;

    public StructureEntry(int x, int y, int z, EnumFacing face, StructureTemplate template) {
        this.name = template.name;
        this.bb = new StructureBB(new BlockPos(x, y, z), face, template.getSize(), template.getOffset());
        this.value = template.getValidationSettings().getClusterValue();
    }

    public StructureEntry(StructureBB bb, String name, int value) {
        this.name = name;
        this.bb = bb;
        this.value = value;
    }

    public StructureEntry() {
        this.bb = new StructureBB(BlockPos.field_177992_a, BlockPos.field_177992_a);
    }

    public void writeToNBT(NBTTagCompound tag) {
        tag.func_74778_a("name", this.name);
        tag.func_74768_a("value", this.value);
        tag.func_74783_a("bb", new int[]{this.bb.min.func_177958_n(), this.bb.min.func_177956_o(), this.bb.min.func_177952_p(), this.bb.max.func_177958_n(), this.bb.max.func_177956_o(), this.bb.max.func_177952_p()});
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.name = tag.func_74779_i("name");
        this.value = tag.func_74762_e("value");
        int[] datas = tag.func_74759_k("bb");
        if (datas.length >= 6) {
            this.bb.min = new BlockPos(datas[0], datas[1], datas[2]);
            this.bb.max = new BlockPos(datas[3], datas[4], datas[5]);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getValue() {
        return this.value;
    }

    public StructureBB getBB() {
        return this.bb;
    }
}

