/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.town.TownPartBlock;

public class TownPartPlot {
    int x;
    int z;
    private int minX;
    private int minZ;
    private int maxX;
    private int maxZ;
    TownPartBlock block;
    StructureBB bb;
    boolean[] roadBorders;
    boolean closed;
    boolean skipped;

    public TownPartPlot(TownPartBlock block, StructureBB bb, int x, int z) {
        this.block = block;
        this.bb = bb;
        this.roadBorders = new boolean[4];
        this.x = x;
        this.z = z;
        this.reseatMinMax();
    }

    public void markClosed() {
        for (int x = this.minX; x <= this.maxX; ++x) {
            for (int z = this.minZ; z <= this.maxZ; ++z) {
                this.block.getPlot((int)x, (int)z).closed = true;
            }
        }
    }

    public boolean hasRoadBorder() {
        for (int i = 0; i < 4; ++i) {
            if (!this.roadBorders[i]) continue;
            return true;
        }
        return false;
    }

    private void reseatMinMax() {
        this.minX = this.x;
        this.minZ = this.z;
        this.maxX = this.x;
        this.maxZ = this.z;
    }

    public void merge(TownPartPlot other) {
        int x = this.bb.min.func_177958_n();
        int z = this.bb.min.func_177952_p();
        if (other.bb.min.func_177958_n() < this.bb.min.func_177958_n()) {
            x = other.bb.min.func_177958_n();
        }
        if (other.bb.min.func_177952_p() < this.bb.min.func_177952_p()) {
            z = other.bb.min.func_177952_p();
        }
        this.bb.min = new BlockPos(x, this.bb.min.func_177956_o(), z);
        x = this.bb.max.func_177958_n();
        z = this.bb.max.func_177952_p();
        if (other.bb.max.func_177958_n() > this.bb.max.func_177958_n()) {
            x = other.bb.max.func_177958_n();
        }
        if (other.bb.max.func_177952_p() > this.bb.max.func_177952_p()) {
            z = other.bb.max.func_177952_p();
        }
        this.bb.max = new BlockPos(x, this.bb.max.func_177956_o(), z);
        for (int i = 0; i < 4; ++i) {
            if (!other.roadBorders[i]) continue;
            this.roadBorders[i] = true;
        }
    }

    public int getWidth() {
        return this.bb.max.func_177958_n() - this.bb.min.func_177958_n() + 1;
    }

    public int getLength() {
        return this.bb.max.func_177952_p() - this.bb.min.func_177952_p() + 1;
    }

    public boolean expand(int xSize, int zSize) {
        StructureBB bb = this.bb.copy();
        boolean val = this.tryExpand(xSize, zSize);
        if (!val) {
            this.reseatMinMax();
            this.bb = bb;
        }
        return val;
    }

    private boolean tryExpand(int xSize, int zSize) {
        while (this.getWidth() < xSize) {
            if (this.expandEast() || this.expandWest()) continue;
            return false;
        }
        while (this.getLength() < zSize) {
            if (this.expandNorth() || this.expandSouth()) continue;
            return false;
        }
        return true;
    }

    private boolean expandNorth() {
        if (this.minZ <= 0) {
            return false;
        }
        for (int x = this.minX; x <= this.maxX; ++x) {
            if (!this.block.getPlot((int)x, (int)(this.minZ - 1)).closed) continue;
            return false;
        }
        --this.minZ;
        TownPartPlot p = this.block.getPlot(this.x, this.minZ);
        this.bb.min = new BlockPos(this.bb.min.func_177958_n(), this.bb.min.func_177956_o(), p.bb.min.func_177952_p());
        return true;
    }

    private boolean expandSouth() {
        if (this.maxZ + 1 >= this.block.plotsLength) {
            return false;
        }
        for (int x = this.minX; x <= this.maxX; ++x) {
            if (!this.block.getPlot((int)x, (int)(this.maxZ + 1)).closed) continue;
            return false;
        }
        ++this.maxZ;
        TownPartPlot p = this.block.getPlot(this.x, this.maxZ);
        this.bb.max = new BlockPos(this.bb.max.func_177958_n(), this.bb.max.func_177956_o(), p.bb.max.func_177952_p());
        return true;
    }

    private boolean expandEast() {
        if (this.minX <= 0) {
            return false;
        }
        for (int z = this.minZ; z <= this.maxZ; ++z) {
            if (!this.block.getPlot((int)(this.minX - 1), (int)z).closed) continue;
            return false;
        }
        --this.minX;
        TownPartPlot p = this.block.getPlot(this.minX, this.z);
        this.bb.min = new BlockPos(p.bb.min.func_177958_n(), this.bb.min.func_177956_o(), this.bb.min.func_177952_p());
        return true;
    }

    private boolean expandWest() {
        if (this.maxX + 1 >= this.block.plotsWidth) {
            return false;
        }
        for (int z = this.minZ; z <= this.maxZ; ++z) {
            if (!this.block.getPlot((int)(this.maxX + 1), (int)z).closed) continue;
            return false;
        }
        ++this.maxX;
        TownPartPlot p = this.block.getPlot(this.maxX, this.z);
        this.bb.max = new BlockPos(p.bb.max.func_177958_n(), this.bb.max.func_177956_o(), this.bb.max.func_177952_p());
        return true;
    }
}

