/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.town.Direction;
import net.shadowmage.ancientwarfare.structure.town.TownPartPlot;
import net.shadowmage.ancientwarfare.structure.town.TownPartQuadrant;

public class TownPartBlock {
    int x;
    int z;
    float distFromTownCenter;
    private boolean[] roadBorders;
    TownPartQuadrant quadrant;
    StructureBB bb;
    List<TownPartPlot> plots;
    private TownPartPlot[] plotsArray;
    int plotsWidth;
    int plotsLength;

    public TownPartBlock(TownPartQuadrant quadrant, StructureBB bb, int x, int z, boolean[] roadBorders, float dist) {
        this.quadrant = quadrant;
        this.bb = bb;
        this.x = x;
        this.z = z;
        this.plots = new ArrayList<TownPartPlot>();
        this.roadBorders = roadBorders;
        this.distFromTownCenter = dist;
    }

    public boolean hasRoadBorder(Direction d) {
        return this.roadBorders[d.ordinal()];
    }

    protected void setRoadBorder(Direction d, boolean val) {
        this.roadBorders[d.ordinal()] = val;
    }

    public void subdivide(int plotSize) {
        int y1 = this.quadrant.gen.maximalBounds.min.func_177956_o();
        int y2 = this.quadrant.gen.maximalBounds.max.func_177956_o();
        int xWidth = this.bb.max.func_177958_n() - this.bb.min.func_177958_n() + 1;
        int zLength = this.bb.max.func_177952_p() - this.bb.min.func_177952_p() + 1;
        int xDivs = xWidth / plotSize;
        if (xWidth % plotSize != 0) {
            ++xDivs;
        }
        int zDivs = zLength / plotSize;
        if (zLength % plotSize != 0) {
            ++zDivs;
        }
        this.plotsWidth = xDivs;
        this.plotsLength = zDivs;
        this.plotsArray = new TownPartPlot[xDivs * zDivs];
        int xStart = this.quadrant.getXDir() == Direction.WEST ? this.bb.max.func_177958_n() : this.bb.min.func_177958_n();
        int widthToUse = xWidth;
        for (int x = 0; x < xDivs; ++x) {
            int xSize = widthToUse > plotSize ? plotSize : widthToUse;
            int xEnd = xStart + (xSize - 1) * this.quadrant.getXDir().xDirection;
            int xIndex = this.quadrant.getXDir() == Direction.WEST ? xDivs - 1 - x : x;
            int zStart = this.quadrant.getZDir() == Direction.NORTH ? this.bb.max.func_177952_p() : this.bb.min.func_177952_p();
            int lengthToUse = zLength;
            for (int z = 0; z < zDivs; ++z) {
                int zSize = lengthToUse > plotSize ? plotSize : lengthToUse;
                int zEnd = zStart + this.quadrant.getZDir().zDirection * (zSize - 1);
                int zIndex = this.quadrant.getZDir() == Direction.NORTH ? zDivs - 1 - z : z;
                TownPartPlot plot = new TownPartPlot(this, new StructureBB(new BlockPos(xStart, y1, zStart), new BlockPos(xEnd, y2, zEnd)), xIndex, zIndex);
                this.setRoadBorders(plot);
                this.plots.add(plot);
                this.setPlot(plot, xIndex, zIndex);
                lengthToUse -= plotSize;
                zStart = zEnd + this.quadrant.getZDir().zDirection;
            }
            widthToUse -= plotSize;
            xStart = xEnd + this.quadrant.getXDir().xDirection;
        }
    }

    private void setPlot(TownPartPlot plot, int x, int z) {
        this.plotsArray[this.getIndex((int)x, (int)z)] = plot;
    }

    private int getIndex(int x, int z) {
        return z * this.plotsWidth + x;
    }

    public TownPartPlot getPlot(int x, int z) {
        if (x < 0 || z < 0 || x >= this.plotsWidth || z >= this.plotsLength) {
            return null;
        }
        return this.plotsArray[this.getIndex(x, z)];
    }

    private void setRoadBorders(TownPartPlot plot) {
        if (this.roadBorders[2] && plot.z == 0) {
            plot.roadBorders[2] = true;
        }
        if (this.roadBorders[0] && plot.z == this.plotsLength - 1) {
            plot.roadBorders[0] = true;
        }
        if (this.roadBorders[1] && plot.x == 0) {
            plot.roadBorders[1] = true;
        }
        if (this.roadBorders[3] && plot.x == this.plotsWidth - 1) {
            plot.roadBorders[3] = true;
        }
    }
}

