/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.town;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilder;
import net.shadowmage.ancientwarfare.structure.town.Direction;
import net.shadowmage.ancientwarfare.structure.town.TownGenerator;
import net.shadowmage.ancientwarfare.structure.town.TownPartBlock;
import net.shadowmage.ancientwarfare.structure.town.TownPartPlot;
import net.shadowmage.ancientwarfare.structure.town.TownPartQuadrant;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldGenTickHandler;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldStructureGenerator;

public class TownGeneratorStructures {
    public static void generateStructures(final TownGenerator gen) {
        final ArrayList<TownPartBlock> blocks = new ArrayList<TownPartBlock>();
        for (TownPartQuadrant tq : gen.quadrants) {
            tq.addBlocks(blocks);
        }
        blocks.sort(new TownPartBlockComparator());
        TownGeneratorStructures.generateUniques(blocks, gen.uniqueTemplatesToGenerate, gen);
        TownGeneratorStructures.generateMains(blocks, gen.mainTemplatesToGenerate, gen);
        TownGeneratorStructures.generateHouses(blocks, gen.houseTemplatesToGenerate, gen);
        TownGeneratorStructures.generateCosmetics(blocks, gen.cosmeticTemplatesToGenerate, gen);
        if (gen.template.getExteriorSize() > 0) {
            blocks.clear();
            for (TownPartQuadrant tq : gen.externalQuadrants) {
                tq.addBlocks(blocks);
            }
            TownGeneratorStructures.generateExteriorStructures(blocks, gen.exteriorTemplatesToGenerate, gen);
        }
        WorldGenTickHandler.INSTANCE.addStructureGenCallback(new WorldGenTickHandler.StructureGenerationCallbackTicket(){

            @Override
            public void call() {
                TownGeneratorStructures.generateLamps(blocks, gen.template.getLamp(), gen);
                WorldStructureGenerator.sprinkleSnow(gen.world, gen.maximalBounds, 0);
                gen.generateVillagers();
            }
        });
    }

    private static void generateUniques(List<TownPartBlock> blocks, List<StructureTemplate> templatesToGenerate, TownGenerator gen) {
        block0: for (TownPartBlock block : blocks) {
            for (TownPartPlot plot : block.plots) {
                if (plot.closed || !plot.hasRoadBorder()) continue;
                if (templatesToGenerate.isEmpty()) break block0;
                if (!TownGeneratorStructures.generateStructureForPlot(gen, plot, templatesToGenerate.get(0), false)) continue;
                templatesToGenerate.remove(0);
            }
        }
    }

    private static void generateMains(List<TownPartBlock> blocks, List<StructureTemplate> templatesToGenerate, TownGenerator gen) {
        block0: for (TownPartBlock block : blocks) {
            for (TownPartPlot plot : block.plots) {
                if (plot.closed || !plot.hasRoadBorder()) continue;
                if (templatesToGenerate.isEmpty()) break block0;
                if (!TownGeneratorStructures.generateStructureForPlot(gen, plot, templatesToGenerate.get(0), false)) continue;
                templatesToGenerate.remove(0);
            }
        }
    }

    private static void generateHouses(List<TownPartBlock> blocks, List<StructureTemplate> templatesToGenerate, TownGenerator gen) {
        block0: for (TownPartBlock block : blocks) {
            for (TownPartPlot plot : block.plots) {
                if (templatesToGenerate.isEmpty()) break block0;
                if (plot.closed || !plot.hasRoadBorder()) continue;
                if (gen.template.getInteriorEmtpyPlotChance() > 0 && gen.rng.nextInt(100) < gen.template.getInteriorEmtpyPlotChance()) {
                    plot.skipped = true;
                    continue;
                }
                TownGeneratorStructures.generateStructureForPlot(gen, plot, TownGeneratorStructures.getRandomTemplate(templatesToGenerate, gen.rng), false);
            }
        }
    }

    private static void generateCosmetics(List<TownPartBlock> blocks, List<StructureTemplate> templatesToGenerate, TownGenerator gen) {
        block0: for (TownPartBlock block : blocks) {
            for (TownPartPlot plot : block.plots) {
                if (plot.closed || plot.skipped) continue;
                if (templatesToGenerate.isEmpty()) break block0;
                TownGeneratorStructures.generateStructureForPlot(gen, plot, TownGeneratorStructures.getRandomTemplate(templatesToGenerate, gen.rng), true);
            }
        }
    }

    private static void generateExteriorStructures(List<TownPartBlock> blocks, List<StructureTemplate> templatesToGenerate, TownGenerator gen) {
        float l1 = (float)gen.exteriorBounds.getXSize() / 2.0f;
        float l2 = (float)gen.exteriorBounds.getZSize() / 2.0f;
        float maxDistance = Trig.getDistance(l1, 0.0, l2, 0.0, 0.0, 0.0);
        l1 = (float)gen.wallsBounds.getXSize() / 2.0f;
        float minDistance = l1 < (l2 = (float)gen.wallsBounds.getZSize() / 2.0f) ? l1 : l2;
        float minMaxDelta = maxDistance - minDistance;
        block0: for (TownPartBlock block : blocks) {
            for (TownPartPlot plot : block.plots) {
                if (plot.closed) continue;
                if (templatesToGenerate.isEmpty()) break block0;
                float plotDistance = Trig.getDistance(plot.bb.getCenterX(), 0.0, plot.bb.getCenterZ(), gen.maximalBounds.getCenterX(), 0.0, gen.maximalBounds.getCenterZ()) - minDistance;
                float distPercent = plotDistance / minMaxDelta;
                distPercent = 1.0f - distPercent;
                distPercent *= distPercent;
                if (!(gen.rng.nextFloat() < distPercent)) continue;
                TownGeneratorStructures.generateStructureForPlot(gen, plot, TownGeneratorStructures.getRandomTemplate(templatesToGenerate, gen.rng), true);
            }
        }
    }

    private static void generateLamps(List<TownPartBlock> blocks, TownTemplate.TownStructureEntry templateToGenerate, TownGenerator gen) {
        if (templateToGenerate == null) {
            return;
        }
        StructureTemplateManager.getTemplate(templateToGenerate.templateName).ifPresent(lamp -> {
            for (TownPartBlock block : blocks) {
                TownGeneratorStructures.generateLamps(gen.world, block, lamp, gen.structureDoors);
            }
        });
    }

    private static void generateLamps(World world, TownPartBlock block, StructureTemplate lamp, List<BlockPos> doors) {
        int z;
        int zBit;
        int x;
        int xBit;
        int zMove;
        int zStart;
        int xMove;
        int xStart;
        Direction xDir = block.quadrant.getXDir();
        Direction zDir = block.quadrant.getZDir();
        int size = 5;
        int xBits = (block.bb.getXSize() - 1) / size;
        int zBits = (block.bb.getZSize() - 1) / size;
        if (block.bb.getXSize() % size == size - 1) {
            --xBits;
        }
        if (block.bb.getZSize() % size == size - 1) {
            --zBits;
        }
        if (xDir == Direction.WEST) {
            xStart = block.bb.max.func_177958_n();
            xMove = -size;
        } else {
            xStart = block.bb.min.func_177958_n();
            xMove = size;
        }
        if (zDir == Direction.NORTH) {
            zStart = block.bb.max.func_177952_p();
            zMove = -size;
        } else {
            zStart = block.bb.min.func_177952_p();
            zMove = size;
        }
        if (block.hasRoadBorder(Direction.NORTH)) {
            for (xBit = 0; xBit <= xBits; ++xBit) {
                x = xBit * xMove + xStart;
                TownGeneratorStructures.generateLamp(world, lamp, doors, x, block.bb.min.func_177956_o(), block.bb.min.func_177952_p(), Direction.EAST);
            }
        }
        if (block.hasRoadBorder(Direction.SOUTH)) {
            for (xBit = 0; xBit <= xBits; ++xBit) {
                x = xBit * xMove + xStart;
                TownGeneratorStructures.generateLamp(world, lamp, doors, x, block.bb.min.func_177956_o(), block.bb.max.func_177952_p(), Direction.EAST);
            }
        }
        if (block.hasRoadBorder(Direction.WEST)) {
            for (zBit = 0; zBit <= zBits; ++zBit) {
                z = zBit * zMove + zStart;
                TownGeneratorStructures.generateLamp(world, lamp, doors, block.bb.min.func_177958_n(), block.bb.min.func_177956_o(), z, Direction.EAST);
            }
        }
        if (block.hasRoadBorder(Direction.EAST)) {
            for (zBit = 0; zBit <= zBits; ++zBit) {
                z = zBit * zMove + zStart;
                TownGeneratorStructures.generateLamp(world, lamp, doors, block.bb.max.func_177958_n(), block.bb.min.func_177956_o(), z, Direction.EAST);
            }
        }
    }

    private static void generateLamp(World world, StructureTemplate t, List<BlockPos> doors, int x, int y, int z, Direction streetSide) {
        if (TownGeneratorStructures.checkForNeighboringDoor(doors, x, z, streetSide.getOpposite())) {
            return;
        }
        int minX = x;
        int minZ = z;
        int maxX = x + t.getSize().func_177958_n() - 1;
        int maxY = y + (t.getSize().func_177956_o() - 1 - t.getOffset().func_177956_o());
        int maxZ = z + t.getSize().func_177952_p() - 1;
        for (int x1 = minX; x1 <= maxX; ++x1) {
            for (int z1 = minZ; z1 <= maxZ; ++z1) {
                for (int y1 = y; y1 <= maxY; ++y1) {
                    if (world.func_175623_d(new BlockPos(x1, y1, z1))) continue;
                    return;
                }
            }
        }
        x -= t.getSize().func_177958_n() / 2;
        z -= t.getSize().func_177952_p() / 2;
        WorldGenTickHandler.INSTANCE.addStructureForGeneration(new StructureBuilder(world, t, EnumFacing.SOUTH, new BlockPos(x += t.getOffset().func_177958_n(), y, z += t.getOffset().func_177952_p())));
    }

    private static boolean checkForNeighboringDoor(List<BlockPos> doors, int x, int z, Direction dir) {
        int x1 = x + dir.xDirection;
        int z1 = z + dir.zDirection;
        for (BlockPos p : doors) {
            if (p.func_177958_n() == x && p.func_177952_p() == z) {
                return true;
            }
            if (p.func_177958_n() != x1 || p.func_177952_p() != z1) continue;
            return true;
        }
        return false;
    }

    private static boolean generateStructureForPlot(TownGenerator gen, TownPartPlot plot, StructureTemplate template, boolean centerLength) {
        int length;
        int expansion = gen.template.getTownBuildingWidthExpansion();
        EnumFacing face = EnumFacing.field_176754_o[gen.rng.nextInt(4)];
        for (int i = 0; i < 4 && !plot.roadBorders[(face = face.func_176746_e()).func_176736_b()]; ++i) {
        }
        int width = (face = face.func_176734_d()).func_176740_k() == EnumFacing.Axis.Z ? template.getSize().func_177958_n() : template.getSize().func_177952_p();
        int n = length = face.func_176740_k() == EnumFacing.Axis.Z ? template.getSize().func_177952_p() : template.getSize().func_177958_n();
        if (face == EnumFacing.SOUTH || face == EnumFacing.NORTH) {
            width += expansion;
        } else {
            length += expansion;
        }
        if (!(plot.getWidth() >= width && plot.getLength() >= length || plot.expand(width, length))) {
            return false;
        }
        plot.markClosed();
        if (face == EnumFacing.SOUTH || face == EnumFacing.NORTH) {
            width -= expansion;
        } else {
            length -= expansion;
        }
        TownGeneratorStructures.generateStructure(gen, plot, template, face, width, length, centerLength);
        return true;
    }

    private static void generateStructure(TownGenerator gen, TownPartPlot plot, StructureTemplate template, EnumFacing face, int width, int length, boolean center) {
        int lAdj;
        int wAdj;
        int plotWidth = plot.getWidth();
        int plotLength = plot.getLength();
        int extraWidth = plotWidth - width;
        int extraLength = plotLength - length;
        if (center) {
            wAdj = extraWidth / 2;
            lAdj = extraLength / 2;
        } else {
            int n = face.func_176740_k() == EnumFacing.Axis.Z ? extraWidth / 2 : (wAdj = face == EnumFacing.WEST ? extraWidth : 0);
            lAdj = face.func_176740_k() == EnumFacing.Axis.X ? extraLength / 2 : (face == EnumFacing.NORTH ? extraLength : 0);
        }
        BlockPos min = new BlockPos(plot.bb.min.func_177958_n() + wAdj, gen.townBounds.min.func_177956_o(), plot.bb.min.func_177952_p() + lAdj);
        BlockPos max = new BlockPos(min.func_177958_n() + (width - 1), min.func_177956_o() + template.getSize().func_177956_o(), min.func_177952_p() + (length - 1));
        StructureBB bb = new StructureBB(min, max);
        BlockPos buildKey = bb.getRLCorner(face, BlockPos.field_177992_a).func_177967_a(face.func_176746_e(), template.getOffset().func_177958_n()).func_177967_a(face.func_176734_d(), template.getOffset().func_177952_p()).func_177981_b(gen.townBounds.min.func_177956_o() - template.getOffset().func_177956_o());
        bb.add(0, -template.getOffset().func_177956_o(), 0);
        gen.structureDoors.add(buildKey);
        WorldGenTickHandler.INSTANCE.addStructureForGeneration(new StructureBuilder(gen.world, template, face, buildKey, bb));
    }

    private static StructureTemplate getRandomTemplate(List<StructureTemplate> templatesToGenerate, Random rng) {
        if (templatesToGenerate.isEmpty()) {
            return null;
        }
        int roll = rng.nextInt(templatesToGenerate.size());
        return templatesToGenerate.get(roll);
    }

    public static class TownPartBlockComparator
    implements Comparator<TownPartBlock> {
        @Override
        public int compare(TownPartBlock o1, TownPartBlock o2) {
            if (o1.distFromTownCenter < o2.distFromTownCenter) {
                return -1;
            }
            if (o1.distFromTownCenter > o2.distFromTownCenter) {
                return 1;
            }
            return 0;
        }
    }
}

