/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundEvent;
import net.shadowmage.ancientwarfare.core.interfaces.ISinger;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.SongPlayData;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;

public class TileSoundBlock
extends TileUpdatable
implements ISinger,
ITickable {
    private int currentDelay;
    private int tuneIndex = -1;
    private int playerCheckDelay;
    private int playerRange = 20;
    private SongPlayData tuneData = new SongPlayData();
    private IBlockState disguiseState;

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.validateAndGetPlaying() && this.tuneData.size() > 0 && this.currentDelay-- <= 0) {
            if (this.tuneData.getPlayOnPlayerEntry()) {
                if (this.playerCheckDelay-- <= 0) {
                    this.playerCheckDelay = 20;
                    if (AncientWarfareStructure.proxy.getClientPlayerDistanceTo(this.field_174879_c) <= (double)this.playerRange) {
                        this.startSong();
                    }
                }
            } else {
                this.startSong();
            }
        }
    }

    private void startSong() {
        if (this.tuneData.getIsRandom()) {
            this.tuneIndex = 0;
            if (this.tuneData.size() > 0) {
                this.tuneIndex = this.field_145850_b.field_73012_v.nextInt(this.tuneData.size());
                this.tuneData.get(this.tuneIndex).getSound().ifPresent(s -> AncientWarfareStructure.proxy.setSoundAt(this.field_174879_c, (SoundEvent)s));
            }
        } else {
            this.tuneIndex = this.tuneIndex + 1 < this.tuneData.size() ? this.tuneIndex + 1 : 0;
            this.tuneData.get(this.tuneIndex).getSound().ifPresent(s -> AncientWarfareStructure.proxy.setSoundAt(this.field_174879_c, (SoundEvent)s));
        }
        AncientWarfareStructure.proxy.playSoundAt(this.field_174879_c);
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        this.func_189515_b(tag);
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.func_145839_a(tag);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.tuneData.readFromNBT(tag.func_74775_l("tuneData"));
        this.tuneIndex = tag.func_74762_e("tuneIndex");
        this.playerRange = tag.func_74762_e("range");
        String id = tag.func_74779_i("block");
        if (!id.isEmpty()) {
            this.disguiseState = Block.func_149684_b((String)id).func_176203_a(tag.func_74762_e("meta"));
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("tuneData", (NBTBase)this.tuneData.writeToNBT(new NBTTagCompound()));
        tag.func_74768_a("tuneIndex", this.tuneIndex);
        tag.func_74768_a("range", this.playerRange);
        if (this.disguiseState != null) {
            tag.func_74778_a("block", this.disguiseState.func_177230_c().getRegistryName().toString());
            tag.func_74768_a("meta", this.disguiseState.func_177230_c().func_176201_c(this.disguiseState));
        }
        return tag;
    }

    @Override
    public SongPlayData getSongs() {
        return this.tuneData;
    }

    public void setPlayerRange(int value) {
        this.playerRange = value;
    }

    public int getPlayerRange() {
        return this.playerRange;
    }

    public IBlockState getDisguiseState() {
        return this.disguiseState;
    }

    public void setDisguiseState(ItemStack itemStack) {
        Block block = Block.func_149634_a((Item)itemStack.func_77973_b());
        if (block != AWStructureBlocks.SOUND_BLOCK && block.func_149686_d(null) && block.func_149662_c(null)) {
            this.disguiseState = block.func_176203_a(itemStack.func_77960_j());
            BlockTools.notifyBlockUpdate(this);
            this.field_145850_b.func_175722_b(this.field_174879_c, this.field_145854_h, true);
            this.func_70296_d();
        }
    }

    private boolean validateAndGetPlaying() {
        if (!AncientWarfareStructure.proxy.hasSoundAt(this.field_174879_c)) {
            return false;
        }
        boolean isPlaying = AncientWarfareStructure.proxy.isSoundPlayingAt(this.field_174879_c);
        if (!isPlaying) {
            this.resetCurrentTune();
        }
        return isPlaying;
    }

    private void resetCurrentTune() {
        this.tuneIndex = -1;
        AncientWarfareStructure.proxy.resetSoundAt(this.field_174879_c);
        int diff = Math.abs(this.tuneData.getMaxDelay() - this.tuneData.getMinDelay());
        this.currentDelay = this.tuneData.getMinDelay() + diff > 0 ? this.field_145850_b.field_73012_v.nextInt(diff) : 0;
    }

    public void func_145843_s() {
        AncientWarfareStructure.proxy.stopSoundAt(this.field_174879_c);
        super.func_145843_s();
    }
}

