/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.shadowmage.ancientwarfare.core.tile.IBlockBreakHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;

public class TileDraftingStation
extends TileEntity
implements ITickable,
IBlockBreakHandler {
    private String structureName;
    private boolean isStarted;
    private List<ItemStack> neededResources = NonNullList.func_191196_a();
    private List<ItemStack> returnResources = NonNullList.func_191196_a();
    private boolean isFinished;
    private int remainingTime;
    private int totalTime;
    public ItemStackHandler inputSlots = new ItemStackHandler(27){

        protected void onContentsChanged(int slot) {
            TileDraftingStation.this.func_70296_d();
        }
    };
    public ItemStackHandler outputSlot = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            TileDraftingStation.this.func_70296_d();
        }
    };

    public void func_73660_a() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (this.structureName != null && !StructureTemplateManager.getTemplate(this.structureName).isPresent()) {
            this.stopCurrentWork();
        }
        if (this.structureName == null || !this.isStarted) {
            return;
        }
        if (!this.isFinished && this.tryRemoveResource()) {
            this.isFinished = true;
        }
        if (this.isFinished && this.tryFinish()) {
            this.stopCurrentWork();
        }
    }

    private boolean tryRemoveResource() {
        block0: for (int k = 0; k < this.inputSlots.getSlots(); ++k) {
            ItemStack stack2 = this.inputSlots.getStackInSlot(k);
            if (stack2.func_190926_b()) continue;
            for (int i = 0; i < this.neededResources.size(); ++i) {
                ItemStack stack1 = this.neededResources.get(i);
                if (!InventoryTools.doItemStacksMatchRelaxed(stack1, stack2)) continue;
                stack1.func_190918_g(1);
                stack2.func_190918_g(1);
                if (stack1.func_190916_E() <= 0) {
                    this.neededResources.remove(i);
                }
                if (stack2.func_190916_E() > 0) break block0;
                this.inputSlots.setStackInSlot(k, ItemStack.field_190927_a);
                break block0;
            }
        }
        return this.neededResources.isEmpty();
    }

    public void tryStart() {
        if (this.structureName != null && StructureTemplateManager.getTemplate(this.structureName) != null) {
            this.isStarted = true;
        }
    }

    private boolean tryFinish() {
        if (this.outputSlot.getStackInSlot(0).func_190926_b()) {
            ItemStack item = new ItemStack(AWStructureBlocks.STRUCTURE_BUILDER_TICKED);
            item.func_77983_a("structureName", (NBTBase)new NBTTagString(this.structureName));
            this.outputSlot.setStackInSlot(0, item);
            InventoryTools.insertOrDropItems((IItemHandler)this.inputSlots, this.returnResources, this.field_145850_b, this.field_174879_c);
            return true;
        }
        return false;
    }

    public String getCurrentTemplateName() {
        return this.structureName;
    }

    public boolean isStarted() {
        return this.isStarted;
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public int getRemainingTime() {
        return this.remainingTime;
    }

    public int getTotalTime() {
        return this.totalTime;
    }

    public List<ItemStack> getNeededResources() {
        return this.neededResources;
    }

    public void stopCurrentWork() {
        this.structureName = null;
        this.neededResources.clear();
        this.remainingTime = 0;
        this.isFinished = false;
        this.isStarted = false;
        this.func_70296_d();
    }

    public void setTemplate(String templateName) {
        if (this.isStarted) {
            return;
        }
        this.structureName = null;
        this.neededResources.clear();
        this.returnResources.clear();
        this.remainingTime = 0;
        StructureTemplateManager.getTemplate(templateName).ifPresent(t -> {
            if (t.getValidationSettings().isSurvival()) {
                this.structureName = templateName;
            }
            for (ItemStack item : t.getResourceList()) {
                this.neededResources.add(item.func_77946_l());
            }
            for (ItemStack item : t.getRemainingStacks()) {
                this.returnResources.add(item.func_77946_l());
            }
            this.calcTime();
        });
        this.func_70296_d();
    }

    private void calcTime() {
        int count = 0;
        for (ItemStack item : this.neededResources) {
            count += item.func_190916_E();
        }
        this.totalTime = this.remainingTime = count;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.inputSlots.deserializeNBT(tag.func_74775_l("inputInventory"));
        this.outputSlot.deserializeNBT(tag.func_74775_l("outputInventory"));
        this.structureName = tag.func_74764_b("structureName") ? tag.func_74779_i("structureName") : null;
        this.isStarted = tag.func_74767_n("isStarted");
        this.isFinished = tag.func_74767_n("isFinished");
        this.remainingTime = tag.func_74762_e("remainingTime");
        this.totalTime = tag.func_74762_e("totalTime");
        this.neededResources = NBTHelper.deserializeItemStackList(tag.func_150295_c("neededResources", 10));
        this.returnResources = NBTHelper.deserializeItemStackList(tag.func_150295_c("returnResources", 10));
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        tag.func_74782_a("inputInventory", (NBTBase)this.inputSlots.serializeNBT());
        tag.func_74782_a("outputInventory", (NBTBase)this.outputSlot.serializeNBT());
        if (this.structureName != null) {
            tag.func_74778_a("structureName", this.structureName);
        }
        tag.func_74757_a("isStarted", this.isStarted);
        tag.func_74757_a("isFinished", this.isFinished);
        tag.func_74768_a("remainingTime", this.remainingTime);
        tag.func_74768_a("totalTime", this.totalTime);
        tag.func_74782_a("neededResources", (NBTBase)NBTHelper.serializeItemStackList(this.neededResources));
        tag.func_74782_a("returnResources", (NBTBase)NBTHelper.serializeItemStackList(this.returnResources));
        return tag;
    }

    @Override
    public void onBlockBroken() {
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.inputSlots, this.field_174879_c);
        InventoryTools.dropItemsInWorld(this.field_145850_b, (IItemHandler)this.outputSlot, this.field_174879_c);
    }
}

