/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityXPOrb;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.tile.IBlockBreakHandler;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.tile.SpawnerSettings;

public class TileAdvancedSpawner
extends TileUpdatable
implements ITickable,
IBlockBreakHandler {
    private SpawnerSettings settings = new SpawnerSettings();

    public void func_145834_a(World world) {
        super.func_145834_a(world);
        this.settings.setWorld(world, this.field_174879_c);
    }

    public void func_174878_a(BlockPos posIn) {
        super.func_174878_a(posIn);
        this.settings.setPos(posIn);
    }

    public void func_73660_a() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K) {
            return;
        }
        if (!this.settings.hasWorld()) {
            this.settings.setWorld(this.field_145850_b, this.field_174879_c);
        }
        this.settings.onUpdate();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        NBTTagCompound ntag = new NBTTagCompound();
        this.settings.writeToNBT(ntag);
        tag.func_74782_a("spawnerSettings", (NBTBase)ntag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.settings.readFromNBT(tag.func_74775_l("spawnerSettings"));
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        super.writeUpdateNBT(tag);
        this.settings.writeToNBT(tag);
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        super.handleUpdateNBT(tag);
        this.settings.readFromNBT(tag);
        this.field_145850_b.func_175704_b(this.field_174879_c, this.field_174879_c);
        BlockTools.notifyBlockUpdate(this);
    }

    public SpawnerSettings getSettings() {
        return this.settings;
    }

    public void setSettings(SpawnerSettings settings) {
        this.settings = settings;
        BlockTools.notifyBlockUpdate(this);
    }

    public float getBlockHardness() {
        return this.settings.blockHardness;
    }

    @Override
    public void onBlockBroken() {
        int j;
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        for (int xp = this.settings.getXpToDrop(); xp > 0; xp -= j) {
            j = EntityXPOrb.func_70527_a((int)xp);
            this.field_145850_b.func_72838_d((Entity)new EntityXPOrb(this.field_145850_b, (double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p() + 0.5, j));
        }
    }
}

