/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.tile.TileUpdatable;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;

public class TEGateProxy
extends TileUpdatable
implements ITickable {
    private static final String RENDER_TAG = "render";
    @Nullable
    private EntityGate owner = null;
    private UUID entityID = null;
    private int clientEntityID = 0;
    private int noParentTicks = 0;
    private boolean render = false;
    private boolean open = false;

    public void setOwner(EntityGate gate) {
        this.owner = gate;
        this.entityID = this.owner.getPersistentID();
        BlockTools.notifyBlockUpdate(this);
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        if (tag.func_74764_b("msb") && tag.func_74764_b("lsb")) {
            long msb = tag.func_74763_f("msb");
            long lsb = tag.func_74763_f("lsb");
            this.entityID = new UUID(msb, lsb);
        }
        this.render = tag.func_74767_n(RENDER_TAG);
        this.open = tag.func_74767_n("open");
        this.func_70296_d();
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        if (this.entityID != null) {
            tag.func_74772_a("msb", this.entityID.getMostSignificantBits());
            tag.func_74772_a("lsb", this.entityID.getLeastSignificantBits());
        }
        tag.func_74757_a(RENDER_TAG, this.render);
        tag.func_74757_a("open", this.open);
        return tag;
    }

    @Override
    protected void writeUpdateNBT(NBTTagCompound tag) {
        tag.func_74757_a(RENDER_TAG, this.render);
        tag.func_74768_a("owner", this.owner != null ? this.owner.func_145782_y() : 0);
        tag.func_74757_a("open", this.open);
        tag.func_74757_a(RENDER_TAG, this.render);
    }

    @Override
    protected void handleUpdateNBT(NBTTagCompound tag) {
        this.render = tag.func_74767_n(RENDER_TAG);
        this.clientEntityID = tag.func_74762_e("owner");
        this.open = tag.func_74767_n("open");
        this.render = tag.func_74767_n(RENDER_TAG);
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return this.getGate().map(EntityGate::func_184177_bl).orElse(super.getRenderBoundingBox());
    }

    public void func_73660_a() {
        if (!this.func_145830_o() || this.field_145850_b.field_72995_K && (!this.render || this.clientEntityID <= 0 || this.owner != null)) {
            return;
        }
        if (this.field_145850_b.field_72995_K) {
            Entity entity = this.field_145850_b.func_73045_a(this.clientEntityID);
            this.owner = entity instanceof EntityGate ? (EntityGate)entity : null;
            return;
        }
        this.handleMissingOwner();
    }

    private void handleMissingOwner() {
        if (this.entityID == null) {
            ++this.noParentTicks;
        } else if (!this.getOwner().isPresent()) {
            ++this.noParentTicks;
            List entities = this.field_145850_b.field_72996_f;
            for (Entity ent : entities) {
                if (!ent.getPersistentID().equals(this.entityID) || !(ent instanceof EntityGate)) continue;
                this.setOwner((EntityGate)ent);
                this.noParentTicks = 0;
                break;
            }
        }
        if (this.noParentTicks >= 100 || this.getOwner().map(o -> o.field_70128_L).orElse(false).booleanValue()) {
            this.owner = null;
            this.field_145850_b.func_175698_g(this.field_174879_c);
        }
    }

    public boolean isGateClosed() {
        return this.getOwner().map(EntityGate::isClosed).orElse(false);
    }

    public Optional<EntityGate> getOwner() {
        return Optional.ofNullable(this.owner);
    }

    public void setRender() {
        this.render = true;
        BlockTools.notifyBlockUpdate(this);
    }

    public boolean doesRender() {
        return this.render;
    }

    public Optional<EntityGate> getGate() {
        return Optional.ofNullable(this.owner);
    }

    public void setOpen(boolean open) {
        this.open = open;
        BlockTools.notifyBlockUpdate(this);
    }

    public boolean isOpen() {
        return this.open;
    }
}

