/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.tile;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.util.math.BlockPos;

public class ScannerCommandTracker {
    private static int currentId = 0;
    private static Map<Integer, CommandType> issuedGlobalCommands = new LinkedHashMap<Integer, CommandType>();
    private static Map<BlockPos, Set<Integer>> executedTileCommands = new HashMap<BlockPos, Set<Integer>>();
    private static Map<BlockPos, Map<Integer, CommandType>> tileCommandsToExecute = new HashMap<BlockPos, Map<Integer, CommandType>>();

    private ScannerCommandTracker() {
    }

    public static void issueGlobalCommand(CommandType type) {
        issuedGlobalCommands.put(currentId++, type);
    }

    public static Optional<CommandType> getAndRemoveNextCommand(BlockPos pos) {
        if (!tileCommandsToExecute.containsKey(pos)) {
            tileCommandsToExecute.put(pos, new LinkedHashMap());
        }
        if (tileCommandsToExecute.get(pos).isEmpty()) {
            Set executed = executedTileCommands.getOrDefault(pos, new HashSet());
            for (Map.Entry<Integer, CommandType> entry : issuedGlobalCommands.entrySet()) {
                if (executed.contains(entry.getKey())) continue;
                tileCommandsToExecute.get(pos).put(entry.getKey(), entry.getValue());
            }
        }
        if (tileCommandsToExecute.get(pos).isEmpty()) {
            return Optional.empty();
        }
        Iterator<Map.Entry<Integer, CommandType>> it = tileCommandsToExecute.get(pos).entrySet().iterator();
        Map.Entry<Integer, CommandType> next = it.next();
        it.remove();
        ScannerCommandTracker.setExecuted(pos, next.getKey());
        return Optional.of(next.getValue());
    }

    private static void setExecuted(BlockPos pos, Integer id) {
        if (!executedTileCommands.containsKey(pos)) {
            executedTileCommands.put(pos, new HashSet());
        }
        executedTileCommands.get(pos).add(id);
    }

    public static enum CommandType {
        RELOAD_MAIN_SETTINGS,
        REEXPORT;

    }
}

