/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.scan;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleBlock;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntityBase;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructurePluginManager;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;

public class TemplateScanner {
    private TemplateScanner() {
    }

    public static StructureTemplate scan(World world, Set<String> modDependencies, BlockPos min, BlockPos max, BlockPos key, int turns, String name) {
        BlockPos destination;
        int xSize = max.func_177958_n() - min.func_177958_n() + 1;
        int ySize = max.func_177956_o() - min.func_177956_o() + 1;
        int zSize = max.func_177952_p() - min.func_177952_p() + 1;
        int xOutSize = xSize;
        int zOutSize = zSize;
        for (int i = 0; i < turns; ++i) {
            int swap = xOutSize;
            xOutSize = zOutSize;
            zOutSize = swap;
        }
        key = BlockTools.rotateInArea(key.func_177973_b((Vec3i)min.func_177982_a(0, -1, 0)), xSize, zSize, turns);
        short[] templateRuleData = new short[xSize * ySize * zSize];
        HashMap<String, List> pluginBlockRuleMap = new HashMap<String, List>();
        HashMap<Integer, TemplateRule> blockRules = new HashMap<Integer, TemplateRule>();
        int nextRuleID = 1;
        for (int scanY = min.func_177956_o(); scanY <= max.func_177956_o(); ++scanY) {
            for (int scanZ = min.func_177952_p(); scanZ <= max.func_177952_p(); ++scanZ) {
                for (int scanX = min.func_177958_n(); scanX <= max.func_177958_n(); ++scanX) {
                    Optional<String> pluginId;
                    destination = BlockTools.rotateInArea(new BlockPos(scanX, scanY, scanZ).func_177973_b((Vec3i)min), xSize, zSize, turns);
                    BlockPos scannedPos = new BlockPos(scanX, scanY, scanZ);
                    IBlockState scannedState = world.func_180495_p(scannedPos);
                    Block scannedBlock = scannedState.func_177230_c();
                    if (AWStructureStatics.shouldSkipScan(scannedBlock) || world.func_175623_d(scannedPos) || !(pluginId = StructurePluginManager.INSTANCE.getPluginNameFor(world, scannedPos, scannedState)).isPresent()) continue;
                    List pluginBlockRules = pluginBlockRuleMap.computeIfAbsent(pluginId.get(), k -> new ArrayList());
                    Optional<Object> scannedBlockRule = Optional.empty();
                    for (TemplateRuleBlock rule : pluginBlockRules) {
                        if (!rule.shouldReuseRule(world, scannedState, turns, scannedPos)) continue;
                        scannedBlockRule = Optional.of(rule);
                        break;
                    }
                    if (!scannedBlockRule.isPresent() && (scannedBlockRule = StructurePluginManager.INSTANCE.getRuleForBlock(world, scannedState, turns, scannedPos)).isPresent()) {
                        ((TemplateRuleBlock)scannedBlockRule.get()).ruleNumber = nextRuleID++;
                        pluginBlockRules.add(scannedBlockRule.get());
                        blockRules.put(((TemplateRuleBlock)scannedBlockRule.get()).ruleNumber, (TemplateRule)scannedBlockRule.get());
                    }
                    int index = StructureTemplate.getIndex((Vec3i)destination, new Vec3i(xOutSize, ySize, zOutSize));
                    templateRuleData[index] = scannedBlockRule.map(r -> (short)r.ruleNumber).orElse((short)-1);
                }
            }
        }
        Tuple<short[], Integer> smallerResult = TemplateScanner.removeTopAirOnlyLayers(xOutSize, ySize, zOutSize, templateRuleData);
        templateRuleData = (short[])smallerResult.func_76341_a();
        ySize = (Integer)smallerResult.func_76340_b();
        HashMap<Integer, TemplateRuleEntityBase> entityRules = new HashMap<Integer, TemplateRuleEntityBase>();
        List entitiesInAABB = world.func_72872_a(Entity.class, new AxisAlignedBB((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p(), (double)(max.func_177958_n() + 1), (double)(max.func_177956_o() + 1), (double)(max.func_177952_p() + 1)));
        nextRuleID = 0;
        for (Entity e : entitiesInAABB) {
            int ez;
            int ey;
            int ex;
            Optional<TemplateRuleEntityBase> scannedEntityRule = StructurePluginManager.INSTANCE.getRuleForEntity(world, e, turns, ex = MathHelper.func_76128_c((double)e.field_70165_t), ey = MathHelper.func_76128_c((double)e.field_70163_u), ez = MathHelper.func_76128_c((double)e.field_70161_v));
            if (!scannedEntityRule.isPresent()) continue;
            destination = BlockTools.rotateInArea(new BlockPos(ex, ey, ez).func_177973_b((Vec3i)min), xSize, zSize, turns);
            scannedEntityRule.get().ruleNumber = nextRuleID;
            scannedEntityRule.get().setPosition(destination);
            entityRules.put(nextRuleID, scannedEntityRule.get());
            ++nextRuleID;
        }
        StructureTemplate template = new StructureTemplate(name, modDependencies, new Vec3i(xOutSize, ySize, zOutSize), (Vec3i)key);
        template.setTemplateData(templateRuleData);
        template.setBlockRules(blockRules);
        template.setEntityRules(entityRules);
        return template;
    }

    private static Tuple<short[], Integer> removeTopAirOnlyLayers(int xSize, int ySize, int zSize, short[] templateRuleData) {
        Vec3i size = new Vec3i(xSize, ySize, zSize);
        for (int y = ySize - 1; y >= 0; --y) {
            if (TemplateScanner.areAllAirInLayer(size, y, templateRuleData)) continue;
            if (y == ySize - 1) {
                return new Tuple((Object)templateRuleData, (Object)ySize);
            }
            return new Tuple((Object)Arrays.copyOf(templateRuleData, xSize * (y + 1) * zSize), (Object)(y + 1));
        }
        return new Tuple((Object)new short[0], (Object)0);
    }

    private static boolean areAllAirInLayer(Vec3i size, int yLayer, short[] templateRuleData) {
        for (int z = 0; z < size.func_177952_p(); ++z) {
            for (int x = 0; x < size.func_177958_n(); ++x) {
                int index = StructureTemplate.getIndex(new Vec3i(x, yLayer, z), size);
                if (templateRuleData[index] == 0) continue;
                return false;
            }
        }
        return true;
    }
}

