/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntitySkull;
import net.minecraft.util.Rotation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.RuleWorld;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.TemplateRuleBlockTile;

public class TemplateRuleVanillaSkull
extends TemplateRuleBlockTile {
    public static final String PLUGIN_NAME = "vanillaSkull";
    private int skullRotation;
    private Tuple<Integer, TileEntitySkull> tileCache;

    public TemplateRuleVanillaSkull(World world, BlockPos pos, IBlockState state, int turns) {
        super(world, pos, state, turns);
        this.skullRotation = Rotation.values()[turns % 4].func_185833_a(this.tag.func_74762_e("Rot"), 16);
    }

    public TemplateRuleVanillaSkull() {
    }

    @Override
    public void handlePlacement(World world, int turns, BlockPos pos, IStructureBuilder builder) {
        super.handlePlacement(world, turns, pos, builder);
        WorldTools.getTile((IBlockAccess)world, pos, TileEntitySkull.class).ifPresent(te -> this.setTileProperties(turns, (TileEntitySkull)te));
    }

    private TileEntitySkull setTileProperties(int turns, TileEntitySkull te) {
        te.func_145903_a(Rotation.values()[turns % 4].func_185833_a(this.skullRotation, 16));
        return te;
    }

    @Override
    protected ItemStack getStack() {
        return new ItemStack(Items.field_151144_bL, 1, (int)this.tag.func_74771_c("SkullType"));
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        super.writeRuleData(tag);
        tag.func_74768_a("skullRotation", (int)((short)this.skullRotation));
    }

    @Override
    public void parseRule(NBTTagCompound tag) {
        super.parseRule(tag);
        this.skullRotation = tag.func_74762_e("skullRotation");
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(int turns) {
        if (this.tileCache == null || (Integer)this.tileCache.func_76341_a() != turns) {
            TileEntitySkull te = this.setTileProperties(turns, (TileEntitySkull)super.getTileEntity(turns));
            te.func_145834_a((World)new RuleWorld(this.getState(turns)));
            this.tileCache = new Tuple((Object)turns, (Object)te);
        }
        return (TileEntity)this.tileCache.func_76340_b();
    }
}

