/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleBlock;
import net.shadowmage.ancientwarfare.structure.block.BlockTotemPart;
import net.shadowmage.ancientwarfare.structure.tile.TileTotemPart;

public class TemplateRuleTotemPart
extends TemplateRuleBlock {
    public static final String PLUGIN_NAME = "totemPart";
    private BlockTotemPart.Variant variant;
    private boolean mainBlock = false;

    public TemplateRuleTotemPart(World world, BlockPos pos, IBlockState state, int turns) {
        super(state, turns);
        Optional<TileTotemPart> te = WorldTools.getTile((IBlockAccess)world, pos, TileTotemPart.class);
        if (!te.isPresent()) {
            return;
        }
        TileTotemPart totem = te.get();
        this.variant = totem.getVariant();
        this.mainBlock = !totem.getMainBlockPos().isPresent();
    }

    public TemplateRuleTotemPart() {
    }

    @Override
    public void handlePlacement(World world, int turns, BlockPos pos, IStructureBuilder builder) {
        if (this.mainBlock) {
            IBlockState rotatedState = BlockTools.rotateFacing(this.state, turns);
            world.func_175656_a(pos, rotatedState);
            WorldTools.getTile((IBlockAccess)world, pos, TileTotemPart.class).ifPresent(te -> te.setVariant(this.variant));
            this.variant.placeAdditionalParts(world, pos, (EnumFacing)rotatedState.func_177229_b((IProperty)CoreProperties.FACING));
        }
    }

    @Override
    public boolean shouldPlaceOnBuildPass(World world, int turns, BlockPos pos, int buildPass) {
        return buildPass == 0;
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    @Override
    public boolean shouldReuseRule(World world, IBlockState state, int turns, BlockPos pos) {
        return false;
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        super.writeRuleData(tag);
        if (this.mainBlock) {
            tag.func_74774_a("variant", (byte)this.variant.getId());
            tag.func_74757_a("mainBlock", this.mainBlock);
        }
    }

    @Override
    public void parseRule(NBTTagCompound tag) {
        super.parseRule(tag);
        this.mainBlock = tag.func_74767_n("mainBlock");
        if (this.mainBlock) {
            this.variant = BlockTotemPart.Variant.fromId(tag.func_74771_c("variant"));
        }
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(int turns) {
        TileTotemPart te = new TileTotemPart();
        te.setVariant(this.variant != null ? this.variant : BlockTotemPart.Variant.WINGS);
        return te;
    }
}

