/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.registry.RegistryNamespaced;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.RuleWorld;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.TemplateRuleVanillaBlocks;

public class TemplateRuleBlockTile
extends TemplateRuleVanillaBlocks {
    public static final String PLUGIN_NAME = "blockTile";
    public NBTTagCompound tag;
    private Tuple<Integer, TileEntity> tileCache = null;
    private static final Field TILE_REGISTRY = ReflectionHelper.findField(TileEntity.class, (String[])new String[]{"field_190562_f", "REGISTRY"});

    public TemplateRuleBlockTile(World world, BlockPos pos, IBlockState state, int turns) {
        super(world, pos, state, turns);
        WorldTools.getTile((IBlockAccess)world, pos).ifPresent(t -> {
            this.tag = new NBTTagCompound();
            t.func_189515_b(this.tag);
            this.tag.func_82580_o("x");
            this.tag.func_82580_o("y");
            this.tag.func_82580_o("z");
        });
    }

    public TemplateRuleBlockTile() {
    }

    @Override
    public void handlePlacement(World world, int turns, BlockPos pos, IStructureBuilder builder) {
        super.handlePlacement(world, turns, pos, builder);
        WorldTools.getTile((IBlockAccess)world, pos).ifPresent(t -> {
            this.tag.func_74768_a("x", pos.func_177958_n());
            this.tag.func_74768_a("y", pos.func_177956_o());
            this.tag.func_74768_a("z", pos.func_177952_p());
            try {
                t.func_145839_a(this.tag);
            }
            catch (Exception e) {
                AncientWarfareStructure.LOG.error("Error loading tile entity data from template for {}: {}", t.getClass(), (Object)e);
            }
        });
    }

    @Override
    public boolean shouldReuseRule(World world, IBlockState state, int turns, BlockPos pos) {
        return false;
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        super.writeRuleData(tag);
        tag.func_74782_a("teData", (NBTBase)this.tag);
    }

    @Override
    public void parseRule(NBTTagCompound tag) {
        super.parseRule(tag);
        this.tag = tag.func_74775_l("teData");
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }

    private Optional<Class<? extends TileEntity>> getTeClass() {
        try {
            return Optional.ofNullable(((RegistryNamespaced)TILE_REGISTRY.get(null)).func_82594_a((Object)new ResourceLocation(this.tag.func_74779_i("id"))));
        }
        catch (IllegalAccessException e) {
            AncientWarfareStructure.LOG.error("Error accessing TileEntity registry: ", (Throwable)e);
            return Optional.empty();
        }
    }

    @Override
    @Nullable
    public TileEntity getTileEntity(int turns) {
        if (this.tileCache == null || (Integer)this.tileCache.func_76341_a() != turns) {
            this.tileCache = new Tuple((Object)turns, this.getTeClass().map(c -> this.instantiateTile((Class<? extends TileEntity>)c, turns)).orElse(null));
        }
        return (TileEntity)this.tileCache.func_76340_b();
    }

    private TileEntity instantiateTile(Class<? extends TileEntity> teClass, int turns) {
        return Arrays.stream(teClass.getConstructors()).filter(c -> c.getParameterCount() == 0).findFirst().map(c -> {
            try {
                TileEntity te = (TileEntity)c.newInstance(new Object[0]);
                te.func_145839_a(this.tag);
                te.func_145834_a((World)new RuleWorld(this.getState(turns)));
                return te;
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                AncientWarfareStructure.LOG.error("Error instantiating tile instance: ", (Throwable)e);
                return null;
            }
        }).orElse(null);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean isDynamicallyRendered(int turns) {
        return TileEntityRendererDispatcher.field_147556_a.func_147547_b(this.getTileEntity(turns)) != null;
    }
}

