/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.api.IStructureBuilder;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.TemplateRuleBlockTile;

public class TemplateRuleBlockInventory
extends TemplateRuleBlockTile {
    private static final String INVENTORY_DATA_TAG = "inventoryData";
    public static final String PLUGIN_NAME = "inventory";
    private static final String SIDED_INVENTORIES_TAG = "sidedInventories";
    private static final String LEGACY_FEATURES_TAG = "legacyFeatures";
    private boolean legacyFeatures;
    private int randomLootLevel;
    private Map<EnumFacing, NonNullList<ItemStack>> inventoryStacks;

    public TemplateRuleBlockInventory() {
    }

    public TemplateRuleBlockInventory(World world, BlockPos pos, IBlockState state, int turns) {
        this(world, pos, state, turns, new EnumFacing[]{null}, false);
    }

    public TemplateRuleBlockInventory(World world, BlockPos pos, IBlockState state, int turns, EnumFacing[] sides, boolean legacyFeatures) {
        super(world, pos, state, turns);
        this.legacyFeatures = legacyFeatures;
        WorldTools.getTile((IBlockAccess)world, pos, TileEntity.class).ifPresent(te -> {
            if (te instanceof TileEntityChest) {
                this.putInInventoryStacks(null, InventoryTools.getItems(((TileEntityChest)te).getSingleChestHandler()));
                this.setLegacyRandomLoot(legacyFeatures, null);
            } else {
                for (EnumFacing side : sides) {
                    InventoryTools.getItemHandlerFrom((ICapabilityProvider)te, side).ifPresent(itemHandler -> {
                        this.putInInventoryStacks(side, InventoryTools.getItems(itemHandler));
                        this.setLegacyRandomLoot(legacyFeatures, side);
                    });
                }
            }
        });
    }

    private void setLegacyRandomLoot(boolean legacyFeatures, @Nullable EnumFacing side) {
        if (legacyFeatures && side == null && this.inventoryStacks.get(null).size() == 1) {
            ItemStack keyStack = (ItemStack)this.inventoryStacks.get(null).get(0);
            if (keyStack.func_77973_b() == Items.field_151043_k) {
                this.randomLootLevel = 1;
            } else if (keyStack.func_77973_b() == Items.field_151045_i) {
                this.randomLootLevel = 2;
            } else if (keyStack.func_77973_b() == Items.field_151166_bC) {
                this.randomLootLevel = 3;
            }
        }
    }

    @Override
    public void addResources(NonNullList<ItemStack> resources) {
        super.addResources(resources);
        for (NonNullList<ItemStack> stacks : this.inventoryStacks.values()) {
            resources.addAll(stacks);
        }
    }

    @Override
    public void handlePlacement(World world, int turns, BlockPos pos, IStructureBuilder builder) {
        super.handlePlacement(world, turns, pos, builder);
        if (this.randomLootLevel > 0) {
            for (Map.Entry<EnumFacing, NonNullList<ItemStack>> inventoryEntry : this.inventoryStacks.entrySet()) {
                WorldTools.getItemHandlerFromTile((IBlockAccess)world, pos, inventoryEntry.getKey()).ifPresent(itemHandler -> {
                    InventoryTools.emptyInventory(itemHandler);
                    InventoryTools.generateLootFor(world, itemHandler, world.field_73012_v, this.randomLootLevel);
                });
            }
        } else if (this.legacyFeatures && this.inventoryStacks.containsKey(null) && !this.tag.func_74764_b("Items")) {
            WorldTools.getItemHandlerFromTile((IBlockAccess)world, pos, null).ifPresent(itemHandler -> InventoryTools.insertItems(itemHandler, (List)this.inventoryStacks.get(null), false));
        }
        BlockTools.notifyBlockUpdate(world, pos);
    }

    @Override
    public boolean shouldReuseRule(World world, IBlockState state, int turns, BlockPos pos) {
        return false;
    }

    @Override
    public void writeRuleData(NBTTagCompound tag) {
        super.writeRuleData(tag);
        tag.func_74768_a("lootLevel", this.randomLootLevel);
        tag.func_74757_a(LEGACY_FEATURES_TAG, this.legacyFeatures);
        for (EnumFacing side : this.inventoryStacks.keySet()) {
            if (side == null) {
                this.writeInventoryForSide(tag, side);
                continue;
            }
            if (!tag.func_74764_b(SIDED_INVENTORIES_TAG)) {
                tag.func_74782_a(SIDED_INVENTORIES_TAG, (NBTBase)new NBTTagCompound());
            }
            NBTTagCompound sidedTag = tag.func_74775_l(SIDED_INVENTORIES_TAG);
            NBTTagCompound sideTag = new NBTTagCompound();
            this.writeInventoryForSide(sideTag, side);
            sidedTag.func_74782_a(side.func_176610_l(), (NBTBase)sideTag);
        }
    }

    private void writeInventoryForSide(NBTTagCompound tag, @Nullable EnumFacing side) {
        NonNullList<ItemStack> stacks = this.inventoryStacks.get(side);
        NBTTagCompound invData = new NBTTagCompound();
        invData.func_74768_a("length", stacks.size());
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < stacks.size(); ++i) {
            ItemStack stack = (ItemStack)stacks.get(i);
            if (stack.func_190926_b()) continue;
            NBTTagCompound itemTag = stack.func_77955_b(new NBTTagCompound());
            itemTag.func_74768_a("slot", i);
            list.func_74742_a((NBTBase)itemTag);
        }
        invData.func_74782_a("inventoryContents", (NBTBase)list);
        tag.func_74782_a(INVENTORY_DATA_TAG, (NBTBase)invData);
    }

    @Override
    public void parseRule(NBTTagCompound tag) {
        super.parseRule(tag);
        if (tag.func_74764_b(INVENTORY_DATA_TAG)) {
            this.parseInventoryForSide(tag, null);
        }
        if (tag.func_74764_b(SIDED_INVENTORIES_TAG)) {
            NBTTagCompound sidedTag = tag.func_74775_l(SIDED_INVENTORIES_TAG);
            for (String key : sidedTag.func_150296_c()) {
                EnumFacing side = EnumFacing.func_176739_a((String)key);
                if (side == null) continue;
                this.parseInventoryForSide(sidedTag.func_74775_l(key), side);
            }
        }
        this.randomLootLevel = tag.func_74762_e("lootLevel");
        this.legacyFeatures = !tag.func_74764_b(LEGACY_FEATURES_TAG) || tag.func_74767_n(LEGACY_FEATURES_TAG);
    }

    private void parseInventoryForSide(NBTTagCompound tag, @Nullable EnumFacing side) {
        NBTTagCompound inventoryTag = tag.func_74775_l(INVENTORY_DATA_TAG);
        int length = inventoryTag.func_74762_e("length");
        NonNullList stacks = NonNullList.func_191197_a((int)length, (Object)ItemStack.field_190927_a);
        NBTTagList list = inventoryTag.func_150295_c("inventoryContents", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound itemTag = list.func_150305_b(i);
            ItemStack stack = new ItemStack(itemTag);
            if (stack.func_190926_b()) continue;
            int slot = itemTag.func_74762_e("slot");
            stacks.set(slot, (Object)stack);
        }
        this.putInInventoryStacks(side, (NonNullList<ItemStack>)stacks);
    }

    private void putInInventoryStacks(@Nullable EnumFacing side, NonNullList<ItemStack> stacks) {
        if (this.inventoryStacks == null) {
            this.inventoryStacks = new HashMap<EnumFacing, NonNullList<ItemStack>>();
        }
        this.inventoryStacks.put(side, stacks);
    }

    @Override
    public String getPluginName() {
        return PLUGIN_NAME;
    }
}

