/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.load;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraftforge.fml.common.Loader;
import net.shadowmage.ancientwarfare.core.util.FileUtils;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;
import net.shadowmage.ancientwarfare.structure.template.load.TemplateParser;
import net.shadowmage.ancientwarfare.structure.template.save.TemplateExporter;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.town.TownTemplateManager;
import net.shadowmage.ancientwarfare.structure.town.TownTemplateParser;
import org.apache.commons.io.FilenameUtils;

public class TemplateLoader {
    private static final String DEFAULT_TEMPLATE_DIRECTORY = "assets/ancientwarfare/template";
    public static final String OUTPUT_DIRECTORY = "config/ancientwarfare/structures/export/";
    public static final String INCLUDE_DIRECTORY = "config/ancientwarfare/structures/included/";
    private List<TownTemplate> parsedTownTemplates = new ArrayList<TownTemplate>();
    public static final TemplateLoader INSTANCE = new TemplateLoader();

    private TemplateLoader() {
    }

    public void initializeAndExportDefaults() {
        File existTest = new File(OUTPUT_DIRECTORY);
        if (!existTest.exists()) {
            existTest.mkdirs();
        }
        if (!(existTest = new File(INCLUDE_DIRECTORY)).exists()) {
            existTest.mkdirs();
        }
    }

    public void loadTemplates() {
        int loadedCount = 0;
        if (AWStructureStatics.loadDefaultPack) {
            loadedCount += this.loadTemplatesFromSource(Loader.instance().activeModContainer().getSource(), DEFAULT_TEMPLATE_DIRECTORY, false);
        }
        AncientWarfareStructure.LOG.info("Loaded " + (loadedCount += this.loadTemplatesFromSource(new File(INCLUDE_DIRECTORY), "", true)) + " structure(s)");
        this.validateTownTemplates();
    }

    public void reloadAll() {
        StructureTemplateManager.removeAll();
        TownTemplateManager.INSTANCE.removeAll();
        this.loadTemplates();
    }

    private int loadTemplatesFromSource(File source, String base, boolean saveFixedTemplate) {
        AtomicInteger loaded = new AtomicInteger(0);
        FileUtils.findFiles(source, base, (root, file) -> {
            String relative = root.relativize((Path)file).toString();
            String name = FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/");
            String extension = FilenameUtils.getExtension((String)file.toString());
            if (extension.equals(AWStructureStatics.townTemplateExtension) || extension.equals(AWStructureStatics.templateExtension)) {
                try (BufferedReader reader = Files.newBufferedReader(file, StandardCharsets.ISO_8859_1);){
                    List<String> lines = reader.lines().filter(l -> !l.startsWith("#")).collect(Collectors.toList());
                    if (extension.equals(AWStructureStatics.townTemplateExtension)) {
                        this.loadTownTemplate(lines);
                    } else {
                        loaded.addAndGet(this.loadTemplate((Path)file, lines, saveFixedTemplate));
                    }
                }
                catch (IOException e) {
                    AncientWarfareStructure.LOG.error("Couldn't read template data {} from {}", (Object)name, file, (Object)e);
                }
                catch (UncheckedIOException e) {
                    AncientWarfareStructure.LOG.error("Couldn't read template data {} from {} - most probable cause is incorrect encoding, should be ISO-8859-1", (Object)name, file, (Object)e);
                }
            }
        });
        return loaded.get();
    }

    private int loadTemplate(Path fileName, List<String> lines, boolean saveFixedTemplate) {
        Optional<FixResult<StructureTemplate>> result = TemplateParser.INSTANCE.parseTemplate(fileName.toString(), lines);
        if (!result.isPresent()) {
            return 0;
        }
        FixResult<StructureTemplate> loadedTemplate = result.get();
        StructureTemplate template = loadedTemplate.getData();
        if (loadedTemplate.isModified()) {
            AncientWarfareStructure.LOG.info("Template {} had following fixes applied: {}", (Object)fileName.toString(), (Object)String.join((CharSequence)", ", loadedTemplate.getFixesApplied()));
        }
        if (saveFixedTemplate && loadedTemplate.isModified()) {
            TemplateExporter.exportTo(template, fileName.getParent().toFile());
            AncientWarfareStructure.LOG.info("Changes saved to {}", (Object)fileName.toString());
        }
        if (template != null) {
            AncientWarfareStructure.LOG.info("Loaded Structure Template: [" + template.name + "] WorldGen: " + template.getValidationSettings().isWorldGenEnabled() + "  Survival: " + template.getValidationSettings().isSurvival());
            StructureTemplateManager.addTemplate(template);
            return 1;
        }
        return 0;
    }

    private void loadTownTemplate(List<String> lines) {
        TownTemplate template = TownTemplateParser.parseTemplate(lines);
        if (template != null) {
            this.parsedTownTemplates.add(template);
        }
    }

    private void validateTownTemplates() {
        if (!this.parsedTownTemplates.isEmpty()) {
            AncientWarfareStructure.LOG.info("Loading Town Templates: ");
            for (TownTemplate t : this.parsedTownTemplates) {
                AncientWarfareStructure.LOG.info("Loading town template: " + t.getTownTypeName());
                t.validateStructureEntries();
                TownTemplateManager.INSTANCE.loadTemplate(t);
            }
            AncientWarfareStructure.LOG.info("Loaded : " + this.parsedTownTemplates.size() + " Town Templates.");
        }
    }
}

