/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.datafixes.fixers;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.RuleNameFixerBase;

public class EntityRuleNameFixer
extends RuleNameFixerBase {
    private static final StructureTemplate.Version VERSION = new StructureTemplate.Version(2, 7);
    private static final Map<String, String> nameMapping = new ImmutableMap.Builder().put((Object)"vanillaLogicEntity", (Object)"entity").put((Object)"vanillaEntities", (Object)"entity").build();

    @Override
    public StructureTemplate.Version getVersion() {
        return VERSION;
    }

    @Override
    public boolean isForRule(String ruleName) {
        return nameMapping.containsKey(ruleName);
    }

    @Override
    protected FixResult<String> fixName(String ruleName) {
        if (nameMapping.containsKey(ruleName)) {
            return new FixResult.Modified<String>(nameMapping.get(ruleName), "EntityRuleNameFixer");
        }
        return new FixResult.NotModified<String>(ruleName);
    }
}

