/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.datafixes.fixers;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.RuleDataFixerBase;

public class EntityPositionToNBTFixer
extends RuleDataFixerBase {
    private static final StructureTemplate.Version VERSION = new StructureTemplate.Version(2, 6);
    private static final Set<String> APPLICABLE_TO_RULES = ImmutableSet.of((Object)"vanillaEntities", (Object)"vanillaHangingEntity", (Object)"vanillaLogicEntity", (Object)"AWNpc", (Object)"awGate");
    private BlockPos position;

    private static int[] parseIntArray(String csv) {
        String[] splits = csv.split(",");
        int[] array = new int[splits.length];
        for (int i = 0; i < splits.length; ++i) {
            array[i] = Integer.parseInt(splits[i].trim());
        }
        return array;
    }

    private static int[] safeParseIntArray(String test) {
        String[] splits = test.split("=");
        if (splits.length > 1) {
            return EntityPositionToNBTFixer.parseIntArray(splits[1]);
        }
        return new int[0];
    }

    @Override
    public FixResult<String> fixData(String ruleName, String data) {
        if (data.contains("position=")) {
            int[] posParts = EntityPositionToNBTFixer.safeParseIntArray(data);
            this.position = new BlockPos(posParts[0], posParts[1], posParts[2]);
            return new FixResult.NotModified<String>(data);
        }
        if (data.startsWith("JSON:")) {
            NBTTagCompound tag;
            try {
                tag = JsonToNBT.func_180713_a((String)data.substring("JSON:".length()));
            }
            catch (NBTException e) {
                AncientWarfareStructure.LOG.error("Error getting nbt from json string: ", (Throwable)e);
                return new FixResult.NotModified<String>(data);
            }
            tag.func_74772_a("position", this.position.func_177986_g());
            return new FixResult.Modified<String>("JSON:" + tag.toString(), "EntityPositionToNBTFixer");
        }
        return new FixResult.NotModified<String>(data);
    }

    @Override
    public StructureTemplate.Version getVersion() {
        return VERSION;
    }

    @Override
    public boolean isForRule(String ruleName) {
        return APPLICABLE_TO_RULES.contains(ruleName);
    }
}

