/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation.properties;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.IStructureValidationProperty;

public class StructureValidationPropertyStringSet
implements IStructureValidationProperty<Set> {
    private String name;
    private Set<String> defaultValue;

    public StructureValidationPropertyStringSet(String name, Set<String> defaultValue) {
        this.name = name;
        this.defaultValue = defaultValue;
    }

    @Override
    public NBTTagCompound serializeNBT(NBTTagCompound tag, Set value) {
        NBTTagList list = new NBTTagList();
        value.forEach(element -> list.func_74742_a((NBTBase)new NBTTagString((String)element)));
        tag.func_74782_a(this.getName(), (NBTBase)list);
        return tag;
    }

    @Override
    public Set<String> deserializeNBT(NBTTagCompound tag) {
        NBTTagList list = tag.func_150295_c(this.getName(), 8);
        HashSet<String> ret = new HashSet<String>();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            ret.add(list.func_150307_f(i));
        }
        return ret;
    }

    @Override
    public Set<String> getDefaultValue() {
        return this.defaultValue;
    }

    @Override
    public String getStringValue(Set value) {
        return StringTools.getCSVValueFor(value);
    }

    @Override
    public Set parseValue(String valueString) {
        return StringTools.parseStringSet(valueString);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public Class<Set> getValueClass() {
        return Set.class;
    }
}

