/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.StructureValidationProperties;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldStructureGenerator;

public class StructureValidatorIsland
extends StructureValidator {
    public StructureValidatorIsland() {
        super(StructureValidationType.ISLAND);
    }

    private int getMinWaterDepth() {
        return this.getPropertyValue(StructureValidationProperties.MIN_WATER_DEPTH);
    }

    private int getMaxWaterDepth() {
        return this.getPropertyValue(StructureValidationProperties.MAX_WATER_DEPTH);
    }

    private void setMinWaterDepth(int depth) {
        this.setPropertyValue(StructureValidationProperties.MIN_WATER_DEPTH, depth);
    }

    private void setMaxWaterDepth(int depth) {
        this.setPropertyValue(StructureValidationProperties.MAX_WATER_DEPTH, depth);
    }

    @Override
    protected void setDefaultSettings(StructureTemplate template) {
        this.setMaxWaterDepth(template.getOffset().func_177956_o());
        this.setMinWaterDepth(this.getMaxWaterDepth() / 2);
    }

    @Override
    public boolean shouldIncludeForSelection(World world, int x, int y, int z, EnumFacing face, StructureTemplate template) {
        int startY = y - 1;
        int water = startY - (y = WorldStructureGenerator.getTargetY(world, x, z, true) + 1) + 1;
        return water >= this.getMinWaterDepth() && water <= this.getMaxWaterDepth();
    }

    @Override
    public boolean validatePlacement(World world, int x, int y, int z, EnumFacing face, StructureTemplate template, StructureBB bb) {
        int minY = y - this.getMaxWaterDepth();
        int maxY = y - this.getMinWaterDepth();
        return this.validateBorderBlocks(world, bb, minY, maxY, true);
    }

    @Override
    public void preGeneration(World world, BlockPos pos, EnumFacing face, StructureTemplate template, StructureBB bb) {
        for (int bx = bb.min.func_177958_n(); bx <= bb.max.func_177958_n(); ++bx) {
            for (int bz = bb.min.func_177952_p(); bz <= bb.max.func_177952_p(); ++bz) {
                BlockPos currentPos;
                for (int by = bb.min.func_177956_o() - 1; by > 0 && !AWStructureStatics.isValidTargetBlock(world.func_180495_p(currentPos = new BlockPos(bx, by, bz))); --by) {
                    world.func_175656_a(currentPos, Blocks.field_150346_d.func_176223_P());
                }
            }
        }
    }

    @Override
    public void handleClearAction(World world, BlockPos pos, StructureTemplate template, StructureBB bb) {
        int maxWaterY = bb.min.func_177956_o() + template.getOffset().func_177956_o() - 1;
        if (pos.func_177956_o() <= maxWaterY) {
            world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
        } else {
            super.handleClearAction(world, pos, template, bb);
        }
    }
}

