/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldStructureGenerator;

public class StructureValidatorHarbor
extends StructureValidator {
    private BlockPos testMin = BlockPos.field_177992_a;
    private BlockPos testMax = BlockPos.field_177992_a;
    private Set<Block> validTargetBlocks = ImmutableSet.of((Object)Blocks.field_150346_d, (Object)Blocks.field_150349_c, (Object)Blocks.field_150348_b, (Object)Blocks.field_150354_m, (Object)Blocks.field_150351_n, (Object)Blocks.field_150322_A, (Object[])new Block[]{Blocks.field_150435_aG, Blocks.field_150366_p, Blocks.field_150365_q});

    public StructureValidatorHarbor() {
        super(StructureValidationType.HARBOR);
    }

    @Override
    protected void setDefaultSettings(StructureTemplate template) {
    }

    @Override
    public boolean shouldIncludeForSelection(World world, int x, int y, int z, EnumFacing face, StructureTemplate template) {
        Block block = world.func_180495_p(new BlockPos(x, y - 1, z)).func_177230_c();
        if (this.validTargetBlocks.contains(block)) {
            this.testMin = new BlockPos(x, y, z).func_177967_a(face, template.getOffset().func_177952_p());
            int by = WorldStructureGenerator.getTargetY(world, this.testMin.func_177958_n(), this.testMin.func_177952_p(), false);
            if (y - by > this.getMaxFill()) {
                return false;
            }
            block = world.func_180495_p(new BlockPos(this.testMin.func_177958_n(), by, this.testMin.func_177952_p())).func_177230_c();
            if (block == Blocks.field_150355_j || block == Blocks.field_150358_i) {
                return true;
            }
        }
        return false;
    }

    @Override
    public int getAdjustedSpawnY(World world, int x, int y, int z, EnumFacing face, StructureTemplate template, StructureBB bb) {
        this.testMin = new BlockPos(x, y, z).func_177967_a(face, template.getOffset().func_177952_p());
        return WorldStructureGenerator.getTargetY(world, this.testMin.func_177958_n(), this.testMin.func_177952_p(), false) + 1;
    }

    @Override
    public boolean validatePlacement(World world, int x, int y, int z, EnumFacing face, StructureTemplate template, StructureBB bb) {
        int bz;
        int bx;
        int minY = this.getMinY(template, bb);
        int maxY = this.getMaxY(template, bb);
        StructureBB temp = bb.getFrontCorners(face, this.testMin, this.testMax);
        this.testMin = temp.min;
        this.testMax = temp.max;
        for (bx = this.testMin.func_177958_n(); bx <= this.testMax.func_177958_n(); ++bx) {
            for (bz = this.testMin.func_177952_p(); bz <= this.testMax.func_177952_p(); ++bz) {
                if (this.validateBlockHeightTypeAndBiome(world, bx, bz, minY, maxY, false)) continue;
                return false;
            }
        }
        temp = bb.getRearCorners(face, this.testMin, this.testMax);
        this.testMin = temp.min;
        this.testMax = temp.max;
        for (bx = this.testMin.func_177958_n(); bx <= this.testMax.func_177958_n(); ++bx) {
            for (bz = this.testMin.func_177952_p(); bz <= this.testMax.func_177952_p(); ++bz) {
                if (this.validateBlockHeightAndType(world, bx, bz, minY, maxY, false, state -> state.func_185904_a() == Material.field_151586_h)) continue;
                return false;
            }
        }
        temp = bb.getRightCorners(face, this.testMin, this.testMax);
        this.testMin = temp.min;
        this.testMax = temp.max;
        for (bx = this.testMin.func_177958_n(); bx <= this.testMax.func_177958_n(); ++bx) {
            for (bz = this.testMin.func_177952_p(); bz <= this.testMax.func_177952_p(); ++bz) {
                if (this.validateBlockHeightAndType(world, bx, bz, minY, maxY, false, state -> AWStructureStatics.isValidTargetBlock(state) || state.func_185904_a() == Material.field_151586_h)) continue;
                return false;
            }
        }
        temp = bb.getLeftCorners(face, this.testMin, this.testMax);
        this.testMin = temp.min;
        this.testMax = temp.max;
        for (bx = this.testMin.func_177958_n(); bx <= this.testMax.func_177958_n(); ++bx) {
            for (bz = this.testMin.func_177952_p(); bz <= this.testMax.func_177952_p(); ++bz) {
                if (this.validateBlockHeightAndType(world, bx, bz, minY, maxY, false, state -> AWStructureStatics.isValidTargetBlock(state) || state.func_185904_a() == Material.field_151586_h)) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public void preGeneration(World world, BlockPos pos, EnumFacing face, StructureTemplate template, StructureBB bb) {
        this.prePlacementBorder(world, template, bb);
    }

    @Override
    public void handleClearAction(World world, BlockPos pos, StructureTemplate template, StructureBB bb) {
        if (pos.func_177956_o() >= bb.min.func_177956_o() + template.getOffset().func_177956_o()) {
            super.handleClearAction(world, pos, template, bb);
        } else {
            world.func_175656_a(pos, Blocks.field_150355_j.func_176223_P());
        }
    }
}

