/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidator;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldStructureGenerator;

public class StructureValidatorGround
extends StructureValidator {
    public StructureValidatorGround() {
        super(StructureValidationType.GROUND);
    }

    @Override
    public boolean shouldIncludeForSelection(World world, int x, int y, int z, EnumFacing face, StructureTemplate template) {
        IBlockState state = world.func_180495_p(new BlockPos(x, y - 1, z));
        Block block = state.func_177230_c();
        if (!AWStructureStatics.isValidTargetBlock(state)) {
            AncientWarfareStructure.LOG.debug("Rejecting due to target block mismatch of: " + block.getRegistryName().toString() + " at: " + x + "," + y + "," + z);
            return false;
        }
        return true;
    }

    @Override
    public boolean validatePlacement(World world, int x, int y, int z, EnumFacing face, StructureTemplate template, StructureBB bb) {
        if (y - template.offset.func_177956_o() <= 0) {
            AncientWarfareStructure.LOG.debug("Ground isn't deep enough for the structure- required: {}, found: {}", (Object)Math.abs(bb.min.func_177956_o()), (Object)y);
            return false;
        }
        int minY = this.getMinY(template, bb);
        int maxY = this.getMaxY(template, bb);
        return this.validateBorderBlocks(world, bb, minY, maxY, false);
    }

    @Override
    public void preGeneration(World world, BlockPos pos, EnumFacing face, StructureTemplate template, StructureBB bb) {
        this.prePlacementBorder(world, template, bb);
        this.prePlacementUnderfill(world, bb);
        if (!this.isPreserveBlocks()) {
            this.clearBB(world, bb);
        }
    }

    private void clearBB(World world, StructureBB bb) {
        BlockTools.getAllInBoxTopDown(bb.min, bb.max).forEach(arg_0 -> ((World)world).func_175698_g(arg_0));
    }

    @Override
    public void postGeneration(World world, BlockPos origin, StructureBB bb) {
        Biome biome = world.field_73011_w.getBiomeForCoords(origin);
        if (biome.func_76746_c()) {
            WorldStructureGenerator.sprinkleSnow(world, bb, this.getBorderSize());
        }
    }

    @Override
    protected void borderLeveling(World world, int x, int z, StructureTemplate template, StructureBB bb) {
        if (this.getMaxLeveling() <= 0) {
            return;
        }
        int topFilledY = Math.max(world.func_181545_F(), WorldStructureGenerator.getTargetY(world, x, z, true));
        int topNonAirBlock = BlockTools.getTopFilledHeight(world.func_175726_f(new BlockPos(x, 1, z)), x, z, false);
        int step = WorldStructureGenerator.getStepNumber(x, z, bb.min.func_177958_n(), bb.max.func_177958_n(), bb.min.func_177952_p(), bb.max.func_177952_p());
        int startY = Math.min(bb.min.func_177956_o() + template.getOffset().func_177956_o() + step, topFilledY + 1);
        for (int y = topNonAirBlock; y >= startY; --y) {
            this.handleClearAction(world, new BlockPos(x, y, z), template, bb);
        }
        Biome biome = world.field_73011_w.getBiomeForCoords(new BlockPos(x, 1, z));
        IBlockState fillBlock = biome.field_76752_A;
        int y = bb.min.func_177956_o() + template.getOffset().func_177956_o() + step - 1;
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block != Blocks.field_150358_i && block != Blocks.field_150355_j && !AWStructureStatics.isSkippable(state)) {
            world.func_175656_a(pos, fillBlock);
        }
    }
}

