/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build.validation;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.shadowmage.ancientwarfare.automation.registry.TreeFarmRegistry;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ITree;
import net.shadowmage.ancientwarfare.automation.tile.worksite.treefarm.ITreeScanner;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.validation.StructureValidationType;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.IStructureValidationProperty;
import net.shadowmage.ancientwarfare.structure.template.build.validation.properties.StructureValidationProperties;
import net.shadowmage.ancientwarfare.structure.worldgen.WorldStructureGenerator;

public abstract class StructureValidator {
    public final StructureValidationType validationType;
    private boolean riverBiomeChecked = false;
    private boolean canSpawnInRiverBiome = false;
    private HashMap<IStructureValidationProperty<?>, Object> properties = new LinkedHashMap();
    private static final Pattern NAME_VALUE_MATCHER = Pattern.compile("([^=]*)=([^=]*)");

    protected StructureValidator(StructureValidationType validationType) {
        this.validationType = validationType;
        for (IStructureValidationProperty property : validationType.getValidationProperties()) {
            this.properties.put(property, property.getDefaultValue());
        }
    }

    public void inheritPropertiesFrom(StructureValidator validator) {
        for (IStructureValidationProperty<?> property : this.properties.keySet()) {
            if (!validator.properties.containsKey(property)) continue;
            this.properties.put(property, validator.properties.get(property));
        }
    }

    public final void readFromNBT(NBTTagCompound tag) {
        for (Map.Entry<IStructureValidationProperty<?>, Object> entry : this.properties.entrySet()) {
            entry.setValue(entry.getKey().deserializeNBT(tag));
        }
    }

    public final NBTTagCompound serializeToNBT() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("validationType", this.validationType.getName());
        for (Map.Entry<IStructureValidationProperty<?>, Object> entry : this.properties.entrySet()) {
            this.serializePropertyNBT(tag, entry.getKey(), entry.getValue());
        }
        return tag;
    }

    private <T> void serializePropertyNBT(NBTTagCompound tag, IStructureValidationProperty<T> property, Object value) {
        property.serializeNBT(tag, property.getValueClass().cast(value));
    }

    protected void setDefaultSettings(StructureTemplate template) {
    }

    public abstract boolean shouldIncludeForSelection(World var1, int var2, int var3, int var4, EnumFacing var5, StructureTemplate var6);

    public int getAdjustedSpawnY(World world, int x, int y, int z, EnumFacing face, StructureTemplate template, StructureBB bb) {
        return y;
    }

    public abstract boolean validatePlacement(World var1, int var2, int var3, int var4, EnumFacing var5, StructureTemplate var6, StructureBB var7);

    public abstract void preGeneration(World var1, BlockPos var2, EnumFacing var3, StructureTemplate var4, StructureBB var5);

    public void postGeneration(World world, BlockPos origin, StructureBB bb) {
    }

    public void handleClearAction(World world, BlockPos pos, StructureTemplate template, StructureBB bb) {
        if (this.isPreserveBlocks()) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (state.func_185904_a() != Material.field_151579_a) {
            Optional<ITreeScanner> treeScanner = TreeFarmRegistry.getRegisteredTreeScanner(state);
            if (!treeScanner.isPresent()) {
                world.func_175698_g(pos);
                return;
            }
            ITree tree = treeScanner.get().scanTree(world, pos);
            tree.getLeafPositions().forEach(arg_0 -> ((World)world).func_175698_g(arg_0));
            tree.getTrunkPositions().forEach(arg_0 -> ((World)world).func_175698_g(arg_0));
        }
    }

    public static StructureValidator parseValidator(List<String> lines) {
        StructureValidationType type = StructureValidationType.GROUND;
        Iterator<String> it = lines.iterator();
        if (it.hasNext()) {
            type = StructureValidator.parseType(it.next());
        }
        StructureValidator validator = type.getValidator();
        while (it.hasNext()) {
            StructureValidator.parseLine(it.next(), validator::parsePropertyValue);
        }
        if (!validator.isDimensionWhiteList() && validator.getAcceptedDimensions().length == 0) {
            validator.setPropertyValue(StructureValidationProperties.DIMENSION_WHITE_LIST, true);
            validator.setPropertyValue(StructureValidationProperties.DIMENSION_LIST, new int[]{0});
        }
        return validator;
    }

    private void parsePropertyValue(String name, String value) {
        for (IStructureValidationProperty<?> property : this.properties.keySet()) {
            if (!property.getName().equalsIgnoreCase(name)) continue;
            this.parsePropertyValue(property, value);
        }
    }

    private <T> void parsePropertyValue(IStructureValidationProperty<T> property, String stringValue) {
        T value = property.parseValue(stringValue);
        this.setPropertyValue(property, value);
    }

    private static void parseLine(String line, BiConsumer<String, String> parseNameValue) {
        Matcher matcher = NAME_VALUE_MATCHER.matcher(line);
        if (matcher.matches()) {
            parseNameValue.accept(matcher.group(1), matcher.group(2));
        }
    }

    private static StructureValidationType parseType(String line) {
        Matcher matcher = NAME_VALUE_MATCHER.matcher(line);
        if (matcher.matches() && matcher.group(1).equalsIgnoreCase("type")) {
            return StructureValidationType.getTypeFromName(matcher.group(2)).orElse(StructureValidationType.GROUND);
        }
        return StructureValidationType.GROUND;
    }

    private static <T> String getStringValue(StructureValidator validator, IStructureValidationProperty<T> property) {
        T value = validator.getPropertyValue(property);
        return property.getStringValue(value);
    }

    public static void writeValidator(BufferedWriter out, StructureValidator validator) throws IOException {
        out.write("type=" + validator.validationType.getName());
        out.newLine();
        for (IStructureValidationProperty<?> property : validator.properties.keySet()) {
            out.write(property.getName() + "=" + StructureValidator.getStringValue(validator, property));
            out.newLine();
        }
    }

    public <T> void setPropertyValue(IStructureValidationProperty<T> property, T value) {
        if (!this.properties.containsKey(property)) {
            throw new IllegalArgumentException("Unable to update property - validator doesn't have property: " + property.getName());
        }
        this.properties.put(property, value);
    }

    public <T> T getPropertyValue(IStructureValidationProperty<T> property) {
        if (!this.properties.containsKey(property)) {
            throw new IllegalArgumentException("Unable to get property value - validator doesn't have property: " + property.getName());
        }
        return property.getValueClass().cast(this.properties.get(property));
    }

    public final StructureValidator setDefaults(StructureTemplate template) {
        this.setDefaultSettings(template);
        return this;
    }

    public final void setBiomeWhiteList(boolean val) {
        this.setPropertyValue(StructureValidationProperties.BIOME_WHITE_LIST, val);
    }

    public final void setDimensionWhiteList(boolean val) {
        this.setPropertyValue(StructureValidationProperties.DIMENSION_WHITE_LIST, val);
    }

    public final boolean isBlockSwap() {
        return this.getPropertyValue(StructureValidationProperties.BLOCK_SWAP);
    }

    public final int getSelectionWeight() {
        return this.getPropertyValue(StructureValidationProperties.SELECTION_WEIGHT);
    }

    public final int getClusterValue() {
        return this.getPropertyValue(StructureValidationProperties.CLUSTER_VALUE);
    }

    public final boolean isWorldGenEnabled() {
        return this.getPropertyValue(StructureValidationProperties.WORLD_GEN);
    }

    public final boolean isPreserveBlocks() {
        return this.getPropertyValue(StructureValidationProperties.PRESERVE_BLOCKS);
    }

    public final boolean isBiomeWhiteList() {
        return this.getPropertyValue(StructureValidationProperties.BIOME_WHITE_LIST);
    }

    public final boolean isUnique() {
        return this.getPropertyValue(StructureValidationProperties.UNIQUE);
    }

    public final boolean isDimensionWhiteList() {
        return this.getPropertyValue(StructureValidationProperties.DIMENSION_WHITE_LIST);
    }

    public final int[] getAcceptedDimensions() {
        return this.getPropertyValue(StructureValidationProperties.DIMENSION_LIST);
    }

    public final void setValidDimension(Set<Integer> dims) {
        int[] dimsa = new int[dims.size()];
        int index = 0;
        for (Integer dim : dims) {
            dimsa[index] = dim;
            ++index;
        }
        this.setPropertyValue(StructureValidationProperties.DIMENSION_LIST, dimsa);
    }

    public final int getMinDuplicateDistance() {
        return this.getPropertyValue(StructureValidationProperties.MIN_DUPLICATE_DISTANCE);
    }

    public final void setBiomeList(Set<String> biomes) {
        this.setPropertyValue(StructureValidationProperties.BIOME_LIST, biomes);
    }

    public Set<String> getBiomeList() {
        return this.getPropertyValue(StructureValidationProperties.BIOME_LIST);
    }

    int getMaxFill() {
        return this.getPropertyValue(StructureValidationProperties.MAX_FILL);
    }

    int getMaxLeveling() {
        return this.getPropertyValue(StructureValidationProperties.MAX_LEVELING);
    }

    public int getBorderSize() {
        return this.getPropertyValue(StructureValidationProperties.BORDER_SIZE);
    }

    boolean validateBorderBlocks(World world, StructureBB bb, int minY, int maxY, boolean skipWater) {
        int bz;
        int bx;
        int borderSize = this.getBorderSize();
        for (bx = bb.min.func_177958_n() - borderSize; bx <= bb.max.func_177958_n() + borderSize; ++bx) {
            bz = bb.min.func_177952_p() - borderSize;
            if (!this.validateBlockHeightTypeAndBiome(world, bx, bz, minY, maxY, skipWater)) {
                return false;
            }
            bz = bb.max.func_177952_p() + borderSize;
            if (this.validateBlockHeightTypeAndBiome(world, bx, bz, minY, maxY, skipWater)) continue;
            return false;
        }
        for (bz = bb.min.func_177952_p() - borderSize + 1; bz <= bb.max.func_177952_p() + borderSize - 1; ++bz) {
            bx = bb.min.func_177958_n() - borderSize;
            if (!this.validateBlockHeightTypeAndBiome(world, bx, bz, minY, maxY, skipWater)) {
                return false;
            }
            bx = bb.max.func_177958_n() + borderSize;
            if (this.validateBlockHeightTypeAndBiome(world, bx, bz, minY, maxY, skipWater)) continue;
            return false;
        }
        return true;
    }

    private boolean canSpawnInRiverBiome() {
        if (!this.riverBiomeChecked) {
            this.canSpawnInRiverBiome = this.getPropertyValue(StructureValidationProperties.BIOME_WHITE_LIST) != false && this.getPropertyValue(StructureValidationProperties.BIOME_LIST).stream().anyMatch(name -> {
                Biome biome = (Biome)Biome.field_185377_q.func_82594_a((Object)new ResourceLocation((String)name));
                return biome != null && BiomeDictionary.hasType((Biome)biome, (BiomeDictionary.Type)BiomeDictionary.Type.RIVER);
            });
            this.riverBiomeChecked = true;
        }
        return this.canSpawnInRiverBiome;
    }

    boolean validateBlockHeightAndType(World world, int x, int z, int min, int max, boolean skipWater, Predicate<IBlockState> isValidState) {
        return this.validateBlockType(world, x, this.validateBlockHeight(world, x, z, min, max, skipWater), z, isValidState);
    }

    private boolean validateBlockHeightTypeAndBiome(World world, int x, int z, int min, int max, boolean skipWater, Predicate<IBlockState> isValidState) {
        BlockPos pos = new BlockPos(x, 1, z);
        if (!this.canSpawnInRiverBiome() && BiomeDictionary.hasType((Biome)world.field_73011_w.getBiomeForCoords(pos), (BiomeDictionary.Type)BiomeDictionary.Type.RIVER)) {
            AncientWarfareStructure.LOG.debug("Rejected for placement into river biome at {}", (Object)pos.toString());
            return false;
        }
        return this.validateBlockHeightAndType(world, x, z, min, max, skipWater, isValidState);
    }

    boolean validateBlockHeightTypeAndBiome(World world, int x, int z, int min, int max, boolean skipWater) {
        return this.validateBlockHeightTypeAndBiome(world, x, z, min, max, skipWater, AWStructureStatics::isValidTargetBlock);
    }

    private int validateBlockHeight(World world, int x, int z, int minimumAcceptableY, int maximumAcceptableY, boolean skipWater) {
        int topFilledY = WorldStructureGenerator.getTargetY(world, x, z, skipWater);
        if (topFilledY < minimumAcceptableY || topFilledY > maximumAcceptableY) {
            AncientWarfareStructure.LOG.debug("rejected for leveling or depth test. foundY: {} min: {} max: {} at: {},{},{}", (Object)topFilledY, (Object)minimumAcceptableY, (Object)maximumAcceptableY, (Object)x, (Object)topFilledY, (Object)z);
            return -1;
        }
        return topFilledY;
    }

    private boolean validateBlockType(World world, int x, int y, int z, Predicate<IBlockState> isValidState) {
        if (y <= 0 || y >= world.func_72800_K()) {
            return false;
        }
        IBlockState state = world.func_180495_p(new BlockPos(x, y, z));
        Block block = state.func_177230_c();
        if (block == Blocks.field_150350_a) {
            AncientWarfareStructure.LOG.debug("rejected for non-matching block: air at: {},{},{} ", (Object)x, (Object)y, (Object)z);
            return false;
        }
        if (!isValidState.test(state)) {
            AncientWarfareStructure.LOG.debug("Rejected for non-matching block: {} at: {},{},{} ", (Object)block.getRegistryName(), (Object)x, (Object)y, (Object)z);
            return false;
        }
        return true;
    }

    int getMinY(StructureTemplate template, StructureBB bb) {
        int minY = bb.min.func_177956_o() - this.getMaxFill() - 1;
        if (this.getBorderSize() > 0) {
            minY += template.getOffset().func_177956_o();
        }
        return minY;
    }

    int getMaxY(StructureTemplate template, StructureBB bb) {
        return bb.min.func_177956_o() + template.getOffset().func_177956_o() + this.getMaxLeveling();
    }

    private int getMaxFillY(StructureTemplate template, StructureBB bb) {
        return this.getMinY(template, bb) + this.getMaxFill();
    }

    protected void borderLeveling(World world, int x, int z, StructureTemplate template, StructureBB bb) {
        if (this.getMaxLeveling() <= 0) {
            return;
        }
        int topFilledY = WorldStructureGenerator.getTargetY(world, x, z, true);
        int step = WorldStructureGenerator.getStepNumber(x, z, bb.min.func_177958_n(), bb.max.func_177958_n(), bb.min.func_177952_p(), bb.max.func_177952_p());
        for (int y = bb.min.func_177956_o() + template.getOffset().func_177956_o() + step; y <= topFilledY; ++y) {
            this.handleClearAction(world, new BlockPos(x, y, z), template, bb);
        }
        Biome biome = world.field_73011_w.getBiomeForCoords(new BlockPos(x, 1, z));
        IBlockState fillBlock = biome.field_76752_A;
        int y = bb.min.func_177956_o() + template.getOffset().func_177956_o() + step - 1;
        BlockPos pos = new BlockPos(x, y, z);
        IBlockState state = world.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block != Blocks.field_150350_a && state.func_185904_a() != Material.field_151586_h && !AWStructureStatics.isSkippable(state)) {
            world.func_175656_a(pos, fillBlock);
        }
    }

    private void borderFill(World world, int x, int z, StructureTemplate template, StructureBB bb) {
        if (this.getMaxFill() <= 0) {
            return;
        }
        int maxFillY = this.getMaxFillY(template, bb);
        int step = WorldStructureGenerator.getStepNumber(x, z, bb.min.func_177958_n(), bb.max.func_177958_n(), bb.min.func_177952_p(), bb.max.func_177952_p());
        Biome biome = world.field_73011_w.getBiomeForCoords(new BlockPos(x, 1, z));
        IBlockState fillBlock = biome.field_76752_A;
        for (int y = maxFillY -= step; y > 1; --y) {
            BlockPos pos = new BlockPos(x, y, z);
            IBlockState state = world.func_180495_p(pos);
            Block block = state.func_177230_c();
            if (!AWStructureStatics.isSkippable(state) && block != Blocks.field_150355_j && block != Blocks.field_150358_i) continue;
            world.func_175656_a(pos, fillBlock);
        }
    }

    private void underFill(World world, int x, int z, StructureBB bb) {
        int topFilledY = WorldStructureGenerator.getTargetY(world, x, z, true);
        Biome biome = world.field_73011_w.getBiomeForCoords(new BlockPos(x, 1, z));
        IBlockState fillBlock = biome.field_76752_A;
        for (int y = topFilledY; y <= bb.min.func_177956_o() - 1; ++y) {
            world.func_175656_a(new BlockPos(x, y, z), fillBlock);
        }
    }

    void prePlacementUnderfill(World world, StructureBB bb) {
        if (this.getMaxFill() <= 0) {
            return;
        }
        for (int bx = bb.min.func_177958_n(); bx <= bb.max.func_177958_n(); ++bx) {
            for (int bz = bb.min.func_177952_p(); bz <= bb.max.func_177952_p(); ++bz) {
                this.underFill(world, bx, bz, bb);
            }
        }
    }

    void prePlacementBorder(World world, StructureTemplate template, StructureBB bb) {
        int bz;
        int bx;
        int borderSize = this.getBorderSize();
        if (borderSize <= 0) {
            return;
        }
        for (bx = bb.min.func_177958_n() - borderSize; bx <= bb.max.func_177958_n() + borderSize; ++bx) {
            for (bz = bb.max.func_177952_p() + borderSize; bz > bb.max.func_177952_p(); --bz) {
                this.borderLeveling(world, bx, bz, template, bb);
                this.borderFill(world, bx, bz, template, bb);
            }
            for (bz = bb.min.func_177952_p() - borderSize; bz < bb.min.func_177952_p(); ++bz) {
                this.borderLeveling(world, bx, bz, template, bb);
                this.borderFill(world, bx, bz, template, bb);
            }
        }
        for (bz = bb.min.func_177952_p(); bz <= bb.max.func_177952_p(); ++bz) {
            for (bx = bb.min.func_177958_n() - borderSize; bx < bb.min.func_177958_n(); ++bx) {
                this.borderLeveling(world, bx, bz, template, bb);
                this.borderFill(world, bx, bz, template, bb);
            }
            for (bx = bb.max.func_177958_n() + borderSize; bx > bb.max.func_177958_n(); --bx) {
                this.borderLeveling(world, bx, bz, template, bb);
                this.borderFill(world, bx, bz, template, bb);
            }
        }
    }

    public boolean isSurvival() {
        return this.getPropertyValue(StructureValidationProperties.SURVIVAL);
    }
}

