/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template.build;

import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.Zone;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;

public class StructureBB
extends Zone {
    public StructureBB(int minX, int minY, int minZ, int maxX, int maxY, int maxZ) {
        super(new BlockPos(minX, minY, minZ), new BlockPos(maxX, maxY, maxZ));
    }

    public StructureBB(BlockPos pos, EnumFacing face, StructureTemplate template) {
        this(pos, face, template.getSize(), template.getOffset());
    }

    public StructureBB(BlockPos pos, EnumFacing face, Vec3i size, Vec3i offset) {
        BlockPos c1 = pos.func_177967_a(face.func_176735_f(), offset.func_177958_n()).func_177967_a(face, offset.func_177952_p()).func_177981_b(-offset.func_177956_o());
        BlockPos c2 = c1.func_177967_a(face.func_176746_e(), size.func_177958_n() - 1).func_177967_a(face, -(size.func_177952_p() - 1)).func_177981_b(size.func_177956_o() - 1);
        this.min = BlockTools.getMin(c1, c2);
        this.max = BlockTools.getMax(c1, c2);
    }

    public StructureBB(BlockPos pos1, BlockPos pos2) {
        super(pos1, pos2);
    }

    private StructureBB() {
    }

    @Override
    public String toString() {
        return this.min.toString() + " : " + this.max.toString();
    }

    public StructureBB expand(int x, int y, int z) {
        this.min = this.min.func_177973_b(new Vec3i(x, y, z));
        this.max = this.max.func_177982_a(x, y, z);
        return this;
    }

    public StructureBB add(int x, int y, int z) {
        this.min = this.min.func_177982_a(x, y, z);
        this.max = this.max.func_177982_a(x, y, z);
        return this;
    }

    public int getXSize() {
        return this.max.func_177958_n() - this.min.func_177958_n() + 1;
    }

    public int getZSize() {
        return this.max.func_177952_p() - this.min.func_177952_p() + 1;
    }

    public int getCenterX() {
        return this.min.func_177958_n() + this.getXSize() / 2 - 1;
    }

    public int getCenterZ() {
        return this.min.func_177952_p() + this.getZSize() / 2 - 1;
    }

    public StructureBB getFrontCorners(EnumFacing face, BlockPos min, BlockPos max) {
        min = this.getFLCorner(face, min);
        max = this.getFRCorner(face, max);
        int minX = Math.min(min.func_177958_n(), max.func_177958_n());
        int maxX = Math.max(min.func_177958_n(), max.func_177958_n());
        int minZ = Math.min(min.func_177952_p(), max.func_177952_p());
        int maxZ = Math.max(min.func_177952_p(), max.func_177952_p());
        StructureBB result = new StructureBB();
        result.min = new BlockPos(minX, min.func_177956_o(), minZ);
        result.max = new BlockPos(maxX, max.func_177956_o(), maxZ);
        return result;
    }

    public StructureBB getLeftCorners(EnumFacing face, BlockPos min, BlockPos max) {
        min = this.getFLCorner(face, min);
        max = this.getRLCorner(face, max);
        int minX = Math.min(min.func_177958_n(), max.func_177958_n());
        int maxX = Math.max(min.func_177958_n(), max.func_177958_n());
        int minZ = Math.min(min.func_177952_p(), max.func_177952_p());
        int maxZ = Math.max(min.func_177952_p(), max.func_177952_p());
        StructureBB result = new StructureBB();
        result.min = new BlockPos(minX, min.func_177956_o(), minZ);
        result.max = new BlockPos(maxX, max.func_177956_o(), maxZ);
        return result;
    }

    public StructureBB getRearCorners(EnumFacing face, BlockPos min, BlockPos max) {
        min = this.getRLCorner(face, min);
        max = this.getRRCorner(face, max);
        int minX = Math.min(min.func_177958_n(), max.func_177958_n());
        int maxX = Math.max(min.func_177958_n(), max.func_177958_n());
        int minZ = Math.min(min.func_177952_p(), max.func_177952_p());
        int maxZ = Math.max(min.func_177952_p(), max.func_177952_p());
        StructureBB result = new StructureBB();
        result.min = new BlockPos(minX, min.func_177956_o(), minZ);
        result.max = new BlockPos(maxX, max.func_177956_o(), maxZ);
        return result;
    }

    public StructureBB getRightCorners(EnumFacing face, BlockPos min, BlockPos max) {
        min = this.getFRCorner(face, min);
        max = this.getRRCorner(face, max);
        int minX = Math.min(min.func_177958_n(), max.func_177958_n());
        int maxX = Math.max(min.func_177958_n(), max.func_177958_n());
        int minZ = Math.min(min.func_177952_p(), max.func_177952_p());
        int maxZ = Math.max(min.func_177952_p(), max.func_177952_p());
        StructureBB result = new StructureBB();
        result.min = new BlockPos(minX, min.func_177956_o(), minZ);
        result.max = new BlockPos(maxX, max.func_177956_o(), maxZ);
        return result;
    }

    private BlockPos getFLCorner(EnumFacing face, BlockPos out) {
        switch (face) {
            case SOUTH: {
                return new BlockPos(this.max.func_177958_n(), this.min.func_177956_o(), this.min.func_177952_p());
            }
            case WEST: {
                return new BlockPos(this.max.func_177958_n(), this.min.func_177956_o(), this.max.func_177952_p());
            }
            case NORTH: {
                return new BlockPos(this.min.func_177958_n(), this.min.func_177956_o(), this.max.func_177952_p());
            }
            case EAST: {
                return this.min;
            }
        }
        return out;
    }

    private BlockPos getFRCorner(EnumFacing face, BlockPos out) {
        switch (face) {
            case SOUTH: {
                return this.min;
            }
            case WEST: {
                return new BlockPos(this.max.func_177958_n(), this.min.func_177956_o(), this.min.func_177952_p());
            }
            case NORTH: {
                return new BlockPos(this.max.func_177958_n(), this.min.func_177956_o(), this.max.func_177952_p());
            }
            case EAST: {
                return new BlockPos(this.min.func_177958_n(), this.min.func_177956_o(), this.max.func_177952_p());
            }
        }
        return out;
    }

    public BlockPos getRLCorner(EnumFacing face, BlockPos out) {
        switch (face) {
            case SOUTH: {
                return new BlockPos(this.max.func_177958_n(), this.min.func_177956_o(), this.max.func_177952_p());
            }
            case WEST: {
                return new BlockPos(this.min.func_177958_n(), this.min.func_177956_o(), this.max.func_177952_p());
            }
            case NORTH: {
                return this.min;
            }
            case EAST: {
                return new BlockPos(this.max.func_177958_n(), this.min.func_177956_o(), this.min.func_177952_p());
            }
        }
        return out;
    }

    private BlockPos getRRCorner(EnumFacing face, BlockPos out) {
        switch (face) {
            case SOUTH: {
                return new BlockPos(this.min.func_177958_n(), this.min.func_177956_o(), this.max.func_177952_p());
            }
            case WEST: {
                return this.min;
            }
            case NORTH: {
                return new BlockPos(this.max.func_177958_n(), this.min.func_177956_o(), this.min.func_177952_p());
            }
            case EAST: {
                return new BlockPos(this.max.func_177958_n(), this.min.func_177956_o(), this.max.func_177952_p());
            }
        }
        return out;
    }

    public StructureBB copy() {
        return new StructureBB(this.min, this.max);
    }

    public double getDistanceTo(StructureBB bb) {
        int xDistance = Math.abs(this.getCenterX() - bb.getCenterX());
        int zDistance = Math.abs(this.getCenterZ() - bb.getCenterZ());
        return Math.sqrt(xDistance * xDistance + zDistance * zDistance);
    }
}

