/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.network.PacketStructure;
import net.shadowmage.ancientwarfare.structure.network.PacketStructureRemove;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.WorldGenStructureManager;

public class StructureTemplateManager {
    private static final String SINGLE_STRUCTURE_TAG = "singleStructure";
    private static final String SYNC_TEMPLATE_TAG = "syncTemplate";
    private static final String STRUCTURE_LIST_TAG = "structureList";
    private static HashMap<String, StructureTemplate> loadedTemplates = new HashMap();
    private static Set<String> allTemplateNames = new HashSet<String>();
    private static Set<String> survivalTemplateNames = new HashSet<String>();
    private static Set<ITemplateObserver> observers = new HashSet<ITemplateObserver>();

    private StructureTemplateManager() {
    }

    public static void addTemplate(StructureTemplate template) {
        if (template.getValidationSettings() == null) {
            return;
        }
        if (template.getValidationSettings().isWorldGenEnabled()) {
            WorldGenStructureManager.INSTANCE.registerWorldGenStructure(template);
        }
        if (loadedTemplates.keySet().contains(template.name)) {
            AncientWarfareStructure.proxy.clearTemplatePreviewCache();
        }
        loadedTemplates.put(template.name, template);
        StructureTemplateManager.syncTemplateToClient(template);
    }

    private static void syncTemplateToClient(StructureTemplate template) {
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            PacketStructure pkt = new PacketStructure();
            pkt.packetData.func_74782_a(SINGLE_STRUCTURE_TAG, (NBTBase)template.serializeNBT());
            NetworkHandler.sendToAllPlayers(pkt);
        }
    }

    public static void onPlayerConnect(EntityPlayerMP player) {
        Set<String> survivalTemplates = loadedTemplates.entrySet().stream().filter(e -> ((StructureTemplate)e.getValue()).getValidationSettings().isSurvival()).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
            PacketStructure pkt = new PacketStructure();
            pkt.packetData.func_74782_a(STRUCTURE_LIST_TAG, (NBTBase)NBTHelper.getNBTStringList(loadedTemplates.keySet()));
            pkt.packetData.func_74782_a("survivalStructures", (NBTBase)NBTHelper.getNBTStringList(survivalTemplates));
            NetworkHandler.sendToPlayer(player, pkt);
        } else {
            survivalTemplateNames = survivalTemplates;
            allTemplateNames = loadedTemplates.keySet();
        }
    }

    public static boolean removeTemplate(String name) {
        if (loadedTemplates.containsKey(name)) {
            loadedTemplates.remove(name);
            if (FMLCommonHandler.instance().getSide() == Side.SERVER) {
                NetworkHandler.sendToAllPlayers(new PacketStructureRemove(name));
            }
            return true;
        }
        return false;
    }

    public static void removeAll() {
        new ArrayList<String>(loadedTemplates.keySet()).forEach(StructureTemplateManager::removeTemplate);
    }

    public static Optional<StructureTemplate> getTemplate(String name) {
        StructureTemplate template = loadedTemplates.get(name);
        if (template == null && FMLCommonHandler.instance().getSide() == Side.CLIENT && allTemplateNames.contains(name)) {
            PacketStructure pkt = new PacketStructure();
            pkt.packetData.func_74778_a(SYNC_TEMPLATE_TAG, name);
            NetworkHandler.sendToServer(pkt);
        }
        return Optional.ofNullable(template);
    }

    public static Map<String, StructureTemplate> getSurvivalStructures() {
        return loadedTemplates.entrySet().stream().filter(e -> ((StructureTemplate)e.getValue()).getValidationSettings().isSurvival()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static void onTemplateData(NBTTagCompound tag) {
        if (tag.func_74764_b(SINGLE_STRUCTURE_TAG)) {
            StructureTemplate template = StructureTemplate.deserializeNBT(tag.func_74775_l(SINGLE_STRUCTURE_TAG));
            StructureTemplateManager.addTemplate(template);
            observers.forEach(observer -> observer.notifyTemplateChange(template));
        } else if (tag.func_74764_b(SYNC_TEMPLATE_TAG)) {
            StructureTemplateManager.getTemplate(tag.func_74779_i(SYNC_TEMPLATE_TAG)).ifPresent(StructureTemplateManager::syncTemplateToClient);
        } else if (tag.func_74764_b(STRUCTURE_LIST_TAG)) {
            loadedTemplates.clear();
            allTemplateNames = NBTHelper.getStringSet(tag.func_150295_c(STRUCTURE_LIST_TAG, 8));
            survivalTemplateNames = NBTHelper.getStringSet(tag.func_150295_c("survivalStructures", 8));
        }
    }

    public static Set<String> getTemplates() {
        return allTemplateNames;
    }

    public static Set<String> getSurvivalTemplates() {
        return survivalTemplateNames;
    }

    public static boolean templateExists(String name) {
        return loadedTemplates.keySet().contains(name);
    }

    public static void registerObserver(ITemplateObserver observer) {
        observers.add(observer);
    }

    public static void unregisterObserver(ITemplateObserver observer) {
        observers.remove(observer);
    }

    public static interface ITemplateObserver {
        public void notifyTemplateChange(StructureTemplate var1);
    }
}

