/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.template;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityHanging;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.api.IStructurePluginRegister;
import net.shadowmage.ancientwarfare.structure.api.StructureContentPlugin;
import net.shadowmage.ancientwarfare.structure.api.StructurePluginRegistrationEvent;
import net.shadowmage.ancientwarfare.structure.api.TemplateParsingException;
import net.shadowmage.ancientwarfare.structure.api.TemplateRule;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleBlock;
import net.shadowmage.ancientwarfare.structure.api.TemplateRuleEntityBase;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.datafixes.DataFixManager;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.StructurePluginAutomation;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.StructurePluginNpcs;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.StructurePluginVanillaHandler;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.StructurePluginVehicles;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.TemplateRuleBlockInventory;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.TemplateRuleBlockTile;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.blockrules.TemplateRuleVanillaBlocks;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.entityrules.TemplateRuleEntity;
import net.shadowmage.ancientwarfare.structure.template.plugin.defaultplugins.entityrules.TemplateRuleEntityHanging;

public class StructurePluginManager
implements IStructurePluginRegister {
    private final List<StructureContentPlugin> loadedContentPlugins = new ArrayList<StructureContentPlugin>();
    private final List<RuleHandler<IBlockDataMatcher, IBlockRuleCreator>> blockRuleHandlers = new ArrayList<RuleHandler<IBlockDataMatcher, IBlockRuleCreator>>();
    private final List<RuleHandler<IEntityMatcher, IEntityRuleCreator>> entityRuleHandlers = new ArrayList<RuleHandler<IEntityMatcher, IEntityRuleCreator>>();
    public static final StructurePluginManager INSTANCE = new StructurePluginManager();

    private StructurePluginManager() {
    }

    public void loadPlugins() {
        this.addPlugin(new StructurePluginVanillaHandler());
        if (Loader.isModLoaded((String)"ancientwarfarenpc")) {
            this.loadNpcPlugin();
        }
        if (Loader.isModLoaded((String)"ancientwarfarevehicle")) {
            this.loadVehiclePlugin();
        }
        if (Loader.isModLoaded((String)"ancientwarfareautomation")) {
            this.loadAutomationPlugin();
        }
        for (StructureContentPlugin plugin : this.loadedContentPlugins) {
            plugin.addHandledBlocks(this);
            plugin.addHandledEntities(this);
        }
        MinecraftForge.EVENT_BUS.post((Event)new StructurePluginRegistrationEvent(this));
        this.registerBlockHandler("inventory", (World world, BlockPos pos, IBlockState state) -> state.func_177230_c().hasTileEntity(state) && WorldTools.hasItemHandler(world, pos), TemplateRuleBlockInventory::new, TemplateRuleBlockInventory::new);
        this.registerBlockHandler("blockTile", (World world, BlockPos pos, IBlockState state) -> state.func_177230_c().hasTileEntity(state) && !WorldTools.hasItemHandler(world, pos), TemplateRuleBlockTile::new, TemplateRuleBlockTile::new);
        this.registerBlockHandler("vanillaBlocks", (World world, BlockPos pos, IBlockState state) -> !state.func_177230_c().hasTileEntity(state), TemplateRuleVanillaBlocks::new, TemplateRuleVanillaBlocks::new);
        this.registerEntityHandler("vanillaHangingEntity", EntityHanging.class::isAssignableFrom, TemplateRuleEntityHanging::new, TemplateRuleEntityHanging::new);
        this.registerEntityHandler("entity", (Class<? extends Entity> clazz) -> Entity.class.isAssignableFrom(clazz) && !EntityPlayer.class.isAssignableFrom(clazz), TemplateRuleEntity::new, TemplateRuleEntity::new);
    }

    private void loadNpcPlugin() {
        this.addPlugin(new StructurePluginNpcs());
        AncientWarfareStructure.LOG.info("Loaded NPC Module Structure Plugin");
    }

    private void loadVehiclePlugin() {
        this.addPlugin(new StructurePluginVehicles());
        AncientWarfareStructure.LOG.info("Loaded Vehicle Module Structure Plugin");
    }

    private void loadAutomationPlugin() {
        this.addPlugin(new StructurePluginAutomation());
        AncientWarfareStructure.LOG.info("Loaded Automation Module Structure Plugin");
    }

    private void addPlugin(StructureContentPlugin plugin) {
        this.loadedContentPlugins.add(plugin);
    }

    public Optional<String> getPluginNameFor(World world, BlockPos pos, IBlockState state) {
        return this.getRuleHandler(world, pos, state).map(h -> ((RuleHandler)h).pluginName);
    }

    public Optional<TemplateRule> getRuleByName(String name) {
        Optional<TemplateRule> result = this.blockRuleHandlers.stream().filter(h -> ((RuleHandler)h).pluginName.equals(name)).findFirst().map(h -> (TemplateRule)((RuleHandler)h).getRule.get());
        if (result.isPresent()) {
            return result;
        }
        return this.entityRuleHandlers.stream().filter(h -> ((RuleHandler)h).pluginName.equals(name)).findFirst().map(h -> (TemplateRule)((RuleHandler)h).getRule.get());
    }

    public Optional<TemplateRuleBlock> getRuleForBlock(World world, IBlockState state, int turns, BlockPos pos) {
        Optional<IBlockRuleCreator> creator = this.getRuleHandler(world, pos, state).map(h -> (IBlockRuleCreator)((RuleHandler)h).ruleCreator);
        return creator.map(c -> c.create(world, pos, state, turns));
    }

    private Optional<RuleHandler<IBlockDataMatcher, IBlockRuleCreator>> getRuleHandler(World world, BlockPos pos, IBlockState state) {
        return this.blockRuleHandlers.stream().filter(h -> ((IBlockDataMatcher)((RuleHandler)h).obj).matches(world, pos, state)).findFirst();
    }

    public Optional<TemplateRuleEntityBase> getRuleForEntity(World world, Entity entity, int turns, int x, int y, int z) {
        return this.entityRuleHandlers.stream().filter(h -> ((IEntityMatcher)((RuleHandler)h).obj).matches(entity.getClass())).findFirst().map(h -> (IEntityRuleCreator)((RuleHandler)h).ruleCreator).map(c -> c.create(world, entity, turns, x, y, z));
    }

    public void registerEntityHandler(String pluginName, IEntityMatcher entityMatcher, IEntityRuleCreator creator, Supplier<TemplateRule> getParser) {
        this.entityRuleHandlers.add(new RuleHandler(this, entityMatcher, pluginName, creator, getParser));
    }

    public void registerEntityHandler(String pluginName, Class<? extends Entity> entityClass, IEntityRuleCreator creator, Supplier<TemplateRule> getParser) {
        this.entityRuleHandlers.add(new RuleHandler(this, entityClass::isAssignableFrom, pluginName, creator, getParser));
    }

    private void registerBlockHandler(String pluginName, IBlockDataMatcher blockMatcher, IBlockRuleCreator creator, Supplier<TemplateRule> getParser) {
        this.blockRuleHandlers.add(new RuleHandler(this, blockMatcher, pluginName, creator, getParser));
    }

    public void registerBlockHandler(String pluginName, Block block, IBlockRuleCreator creator, Supplier<TemplateRule> getParser) {
        this.registerBlockHandler(pluginName, (World world, BlockPos pos, IBlockState state) -> state.func_177230_c() == block, creator, getParser);
    }

    @Override
    public void registerPlugin(StructureContentPlugin plugin) {
        this.addPlugin(plugin);
    }

    public static <T extends TemplateRule> FixResult<T> getRule(StructureTemplate.Version version, List<String> ruleData, String ruleType) throws TemplateParsingException.TemplateRuleParsingException {
        TemplateRule actualRule;
        Optional<TemplateRule> parser;
        Iterator<String> it = ruleData.iterator();
        String name = null;
        int ruleNumber = -1;
        List<String> ruleDataPackage = new ArrayList<String>();
        while (it.hasNext()) {
            String line = it.next();
            if (line.startsWith(ruleType + ":")) continue;
            if (line.startsWith(":end" + ruleType)) break;
            if (line.startsWith("plugin=")) {
                name = StringTools.safeParseString("=", line);
            }
            if (line.startsWith("number=")) {
                ruleNumber = StringTools.safeParseInt("=", line);
            }
            if (!line.startsWith("data:")) continue;
            StructurePluginManager.addData(it, ruleDataPackage);
        }
        if (name == null || ruleNumber < 0 || ruleDataPackage.isEmpty()) {
            throw new TemplateParsingException.TemplateRuleParsingException("Not enough data to create template rule.\nname: " + name + "\nnumber:" + ruleNumber + "\nruleDataPackage.size:" + ruleDataPackage.size() + "\n");
        }
        FixResult.Builder<TemplateRule> resultBuilder = new FixResult.Builder<TemplateRule>();
        if (StructureTemplate.CURRENT_VERSION.isGreaterThan(version)) {
            Tuple<String, List<String>> fixResult = resultBuilder.updateAndGetData(DataFixManager.fixRuleData(version, name, ruleDataPackage));
            name = (String)fixResult.func_76341_a();
            ruleDataPackage = (List)fixResult.func_76340_b();
        }
        if (!(parser = INSTANCE.getRuleByName(name)).isPresent()) {
            throw new TemplateParsingException.TemplateRuleParsingException("Not enough data to create template rule.\nMissing plugin for name: " + name + "\nname: " + name + "\nnumber:" + ruleNumber + "\nruleDataPackage.size:" + ruleDataPackage.size() + "\n");
        }
        TemplateRule rule = parser.get();
        rule.parseRule(StructurePluginManager.readTag(ruleDataPackage));
        rule.ruleNumber = ruleNumber;
        try {
            actualRule = rule;
        }
        catch (ClassCastException e) {
            throw new TemplateParsingException.TemplateRuleParsingException("Incorrect rule type is being returned\n");
        }
        return resultBuilder.build(actualRule);
    }

    private static void addData(Iterator<String> it, List<String> ruleDataPackage) {
        String line;
        while (it.hasNext() && !(line = it.next()).startsWith(":enddata")) {
            ruleDataPackage.add(line);
        }
    }

    private static NBTTagCompound readTag(List<String> ruleData) throws TemplateParsingException.TemplateRuleParsingException {
        for (String line : ruleData) {
            if (!line.startsWith("JSON:")) continue;
            try {
                return JsonToNBT.func_180713_a((String)line.substring("JSON:".length()));
            }
            catch (NBTException e) {
                throw new TemplateParsingException.TemplateRuleParsingException("Issue parsing NBTTagCompound from JSON: " + line, e);
            }
        }
        return new NBTTagCompound();
    }

    public static interface IEntityMatcher {
        public boolean matches(Class<? extends Entity> var1);
    }

    private static interface IBlockDataMatcher {
        public boolean matches(World var1, BlockPos var2, IBlockState var3);
    }

    public static interface IEntityRuleCreator
    extends IRuleCreator {
        public TemplateRuleEntityBase create(World var1, Entity var2, int var3, int var4, int var5, int var6);
    }

    public static interface IBlockRuleCreator
    extends IRuleCreator {
        public TemplateRuleBlock create(World var1, BlockPos var2, IBlockState var3, int var4);
    }

    static interface IRuleCreator {
    }

    private static class RuleHandler<T, U extends IRuleCreator> {
        private final T obj;
        private final String pluginName;
        private U ruleCreator;
        private Supplier<TemplateRule> getRule;
        final /* synthetic */ StructurePluginManager this$0;

        private RuleHandler(T obj, String pluginName, U creator, Supplier<TemplateRule> getRule) {
            this.this$0 = var1_1;
            this.obj = obj;
            this.pluginName = pluginName;
            this.ruleCreator = creator;
            this.getRule = getRule;
        }
    }
}

