/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.sounds;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.Sound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.audio.SoundList;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.client.resource.IResourceType;
import net.minecraftforge.client.resource.ISelectiveResourceReloadListener;
import net.minecraftforge.client.resource.VanillaResourceType;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ProgressManager;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.registries.IForgeRegistryModifiable;
import net.shadowmage.ancientwarfare.core.util.FileUtils;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import org.apache.commons.io.FilenameUtils;

public class SoundLoader
implements ISelectiveResourceReloadListener {
    private static final String DEFAULT_SOUNDS_DIRECTORY = "assets/ancientwarfarestructure/sounds/auto_load";
    private static final Method LOAD_SOUND_RESOURCE = ReflectionHelper.findMethod(SoundHandler.class, (String)"loadSoundResource", (String)"func_147693_a", (Class[])new Class[]{ResourceLocation.class, SoundList.class});

    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> resourcePredicate) {
        if (resourcePredicate.test((IResourceType)VanillaResourceType.SOUNDS)) {
            this.reloadSounds();
        }
    }

    private void loadSoundResource(SoundHandler soundHandler, ResourceLocation location, SoundList sounds) {
        try {
            LOAD_SOUND_RESOURCE.invoke((Object)soundHandler, location, sounds);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            AncientWarfareStructure.LOG.error("Error loading sound {}:\n", (Object)location, (Object)e);
        }
    }

    private void reloadSounds() {
        SoundHandler sndHandler = Minecraft.func_71410_x().func_147118_V();
        HashSet sounds = new HashSet();
        FileUtils.findFiles(Loader.instance().activeModContainer().getSource(), DEFAULT_SOUNDS_DIRECTORY, (root, file) -> {
            String extension = FilenameUtils.getExtension((String)file.toString());
            if (extension.equals("ogg")) {
                String relative = root.relativize((Path)file).toString();
                sounds.add("ancientwarfarestructure:auto_load/" + FilenameUtils.removeExtension((String)relative).replaceAll("\\\\", "/"));
            }
        });
        ProgressManager.ProgressBar resourcesBar = ProgressManager.push((String)"Loading AW sounds", (int)sounds.size());
        sounds.forEach(s -> {
            ResourceLocation location = new ResourceLocation(s);
            this.loadSoundResource(sndHandler, location, new SoundList(Collections.singletonList(new Sound(s, 1.0f, 1.0f, 1, Sound.Type.FILE, false)), false, null));
            if (!((IForgeRegistryModifiable)ForgeRegistries.SOUND_EVENTS).isLocked()) {
                ForgeRegistries.SOUND_EVENTS.register(new SoundEvent(location).setRegistryName(location));
            }
            resourcesBar.step(s);
        });
        ProgressManager.pop((ProgressManager.ProgressBar)resourcesBar);
    }
}

