/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.render.gate;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.render.gate.RenderGateBasic;

public final class RenderGateSingle
extends RenderGateBasic {
    public RenderGateSingle(RenderManager renderManager) {
        super(renderManager);
    }

    @Override
    protected BlockPos getMin(EntityGate gate) {
        return BlockTools.getMin(gate.pos1, gate.pos2);
    }

    @Override
    protected BlockPos getMax(EntityGate gate) {
        return BlockTools.getMax(gate.pos1, gate.pos2);
    }

    @Override
    protected void postRender(EntityGate gate, int x, float width, int y, float height, boolean wideOnXAxis, float axisRotation, float frame) {
        boolean opensReverse = gate.pos1.func_177958_n() > gate.pos2.func_177958_n() || gate.pos1.func_177952_p() < gate.pos2.func_177952_p();
        float wallTx = wideOnXAxis ? gate.edgePosition + gate.openingSpeed * (1.0f - frame) : 0.0f;
        float wallTz = wideOnXAxis ? 0.0f : gate.edgePosition + gate.openingSpeed * (1.0f - frame);
        boolean render = false;
        if (opensReverse) {
            if (wideOnXAxis && (float)x - wallTx > -0.5f || !wideOnXAxis && (float)x - wallTz > -0.5f) {
                render = true;
            }
        } else if (wideOnXAxis && wallTx + (float)x < gate.edgeMax - 0.5f || !wideOnXAxis && wallTz + (float)x < gate.edgeMax - 0.5f) {
            render = true;
        }
        if (render) {
            if (opensReverse) {
                wallTx *= -1.0f;
                wallTz *= -1.0f;
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)wallTx, (float)0.0f, (float)wallTz);
            this.model.setModelRotation(axisRotation);
            if (gate.getGateType().getModelType() == 0) {
                this.model.renderSolidWall();
            } else {
                this.model.renderBars();
            }
            GlStateManager.func_179121_F();
        }
    }
}

