/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.registry;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.BlockSlab;
import net.minecraft.block.BlockSnow;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.shadowmage.ancientwarfare.core.registry.IRegistryDataParser;
import net.shadowmage.ancientwarfare.core.util.parsing.BlockStateMatcher;
import net.shadowmage.ancientwarfare.core.util.parsing.JsonHelper;

public class StructureBlockRegistry {
    private static final Map<BlockStateMatcher, ItemStack> STATE_TO_ITEM = new HashMap<BlockStateMatcher, ItemStack>();
    private static final Map<BlockStateMatcher, ItemStack> STATE_TO_REMAINING_ITEM = new HashMap<BlockStateMatcher, ItemStack>();
    private static final Map<BlockStateMatcher, Integer> STATE_PASS = new HashMap<BlockStateMatcher, Integer>();

    private StructureBlockRegistry() {
    }

    public static ItemStack getItemStackFrom(IBlockState state) {
        for (Map.Entry<BlockStateMatcher, ItemStack> stateItem : STATE_TO_ITEM.entrySet()) {
            if (!stateItem.getKey().test(state)) continue;
            return stateItem.getValue();
        }
        try {
            ItemStack stack = state.func_177230_c().func_185473_a(null, null, state);
            StructureBlockRegistry.updateCountForSpecialBlocks(state, stack);
            return stack;
        }
        catch (NullPointerException ex) {
            return new ItemStack(Items.field_190931_a);
        }
    }

    private static void updateCountForSpecialBlocks(IBlockState state, ItemStack stack) {
        if (state.func_177230_c() instanceof BlockSlab) {
            stack.func_190920_e(2);
        } else if (state.func_177230_c() instanceof BlockSnow) {
            stack.func_190920_e(((Integer)state.func_177229_b((IProperty)BlockSnow.field_176315_a)).intValue());
        }
    }

    public static ItemStack getRemainingStackFrom(IBlockState state) {
        for (Map.Entry<BlockStateMatcher, ItemStack> stateItem : STATE_TO_REMAINING_ITEM.entrySet()) {
            if (!stateItem.getKey().test(state)) continue;
            return stateItem.getValue();
        }
        return ItemStack.field_190927_a;
    }

    public static int getBuildPass(IBlockState state) {
        for (Map.Entry<BlockStateMatcher, Integer> statePass : STATE_PASS.entrySet()) {
            if (!statePass.getKey().test(state)) continue;
            return statePass.getValue();
        }
        return 0;
    }

    public static class Parser
    implements IRegistryDataParser {
        private static final String BLOCK_PROPERTY = "block";

        @Override
        public String getName() {
            return "structure_blocks";
        }

        @Override
        public void parse(JsonObject json) {
            STATE_TO_ITEM.putAll(JsonHelper.mapFromObjectArray(JsonUtils.func_151214_t((JsonObject)json, (String)"blockstate_to_item"), BLOCK_PROPERTY, "item", JsonHelper::getBlockStateMatcher, JsonHelper::getItemStack));
            STATE_TO_REMAINING_ITEM.putAll(JsonHelper.mapFromObjectArray(JsonUtils.func_151214_t((JsonObject)json, (String)"blockstate_to_item"), BLOCK_PROPERTY, "remaining_item", JsonHelper::getBlockStateMatcher, e -> e != null ? JsonHelper.getItemStack(e) : ItemStack.field_190927_a));
            STATE_PASS.putAll(JsonHelper.mapFromObjectArray(JsonUtils.func_151214_t((JsonObject)json, (String)"block_passes"), BLOCK_PROPERTY, "build_pass", JsonHelper::getBlockStateMatcher, e -> Integer.parseInt(JsonUtils.func_151206_a((JsonElement)e, (String)"build_pass"))));
        }
    }
}

