/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.registry;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.passive.EntityHorse;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.JsonUtils;
import net.shadowmage.ancientwarfare.core.registry.IRegistryDataParser;
import net.shadowmage.ancientwarfare.core.util.parsing.JsonHelper;

public class EntitySpawnNBTRegistry {
    private static final Map<Class, Set<String>> entityNBT = new HashMap<Class, Set<String>>();

    private EntitySpawnNBTRegistry() {
    }

    public static NBTTagCompound getEntitySpawnNBT(Entity entity, NBTTagCompound entityTag) {
        NBTTagCompound ret = new NBTTagCompound();
        for (Map.Entry<Class, Set<String>> entry : entityNBT.entrySet()) {
            if (!entry.getKey().isInstance(entity)) continue;
            for (String tag : entry.getValue()) {
                if (!entityTag.func_74764_b(tag)) continue;
                ret.func_74782_a(tag, entityTag.func_74781_a(tag));
            }
        }
        return ret;
    }

    static {
        entityNBT.put(EntityVillager.class, (Set<String>)ImmutableSet.of((Object)"Offers", (Object)"Profession", (Object)"ProfessionName", (Object)"Career", (Object)"CareerLevel"));
        entityNBT.put(EntityHorse.class, Collections.singleton("Variant"));
        entityNBT.put(EntityLiving.class, (Set<String>)ImmutableSet.of((Object)"HandItems", (Object)"HandDropChances", (Object)"ArmorItems", (Object)"ArmorDropChances"));
    }

    public static class Parser
    implements IRegistryDataParser {
        @Override
        public String getName() {
            return "entity_spawn_nbt";
        }

        @Override
        public void parse(JsonObject json) {
            entityNBT.putAll(JsonHelper.mapFromJson(json, "entity_nbt", entry -> this.getClass((String)entry.getKey()), entry -> JsonHelper.setFromJson((JsonElement)entry.getValue(), element -> JsonUtils.func_151206_a((JsonElement)element, (String)""))));
        }

        private Class getClass(String className) {
            try {
                return Class.forName(className);
            }
            catch (ClassNotFoundException e) {
                throw new MissingResourceException("Unable to find class for class name: " + className, Class.class.toString(), className);
            }
        }
    }
}

