/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.proxy;

import codechicken.lib.util.ResourceUtils;
import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.init.Blocks;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.proxy.IClientRegister;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.event.StructureBoundingBoxRenderer;
import net.shadowmage.ancientwarfare.structure.gui.GuiGateControl;
import net.shadowmage.ancientwarfare.structure.gui.GuiGateControlCreative;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.proxy.CommonProxyStructure;
import net.shadowmage.ancientwarfare.structure.render.DraftingStationRenderer;
import net.shadowmage.ancientwarfare.structure.render.ParticleDummyModel;
import net.shadowmage.ancientwarfare.structure.render.PreviewRenderer;
import net.shadowmage.ancientwarfare.structure.render.RenderGateInvisible;
import net.shadowmage.ancientwarfare.structure.sounds.SoundLoader;
import net.shadowmage.ancientwarfare.structure.tile.TileSoundBlock;

@SideOnly(value=Side.CLIENT)
public class ClientProxyStructure
extends CommonProxyStructure {
    private Set<IClientRegister> clientRegisters = Sets.newHashSet();
    private Map<BlockPos, PositionedSoundRecord> currentSounds = new HashMap<BlockPos, PositionedSoundRecord>();

    public ClientProxyStructure() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void registerModels(ModelRegistryEvent event) {
        for (IClientRegister register : this.clientRegisters) {
            register.registerClient();
        }
    }

    @Override
    public void addClientRegister(IClientRegister register) {
        this.clientRegisters.add(register);
    }

    @Override
    public void preInit() {
        super.preInit();
        NetworkHandler.registerGui(11, GuiGateControl.class);
        NetworkHandler.registerGui(58, GuiGateControlCreative.class);
        MinecraftForge.EVENT_BUS.register((Object)StructureBoundingBoxRenderer.INSTANCE);
        MinecraftForge.EVENT_BUS.register((Object)this);
        RenderingRegistry.registerEntityRenderingHandler(EntityGate.class, RenderGateInvisible::new);
        ResourceUtils.registerReloadListener((IResourceManagerReloadListener)ParticleDummyModel.INSTANCE);
    }

    @Override
    public void init() {
        super.init();
        ResourceUtils.registerReloadListener((IResourceManagerReloadListener)new SoundLoader());
        Minecraft.func_71410_x().func_184125_al().func_186722_a((state, world, pos, tintIndex) -> {
            IBlockState disguiseState = WorldTools.getTile(world, pos, TileSoundBlock.class).filter(t -> t.getDisguiseState() != null).map(TileSoundBlock::getDisguiseState).orElse(Blocks.field_150421_aI.func_176223_P());
            return Minecraft.func_71410_x().func_184125_al().func_186724_a(disguiseState, world, pos, 0);
        }, new Block[]{AWStructureBlocks.SOUND_BLOCK});
    }

    @SubscribeEvent
    public void onPreTextureStitch(TextureStitchEvent.Pre evt) {
        DraftingStationRenderer.INSTANCE.setSprite(evt.getMap().func_174942_a(new ResourceLocation("ancientwarfare:model/structure/tile_drafting_station")));
    }

    @Override
    public void clearTemplatePreviewCache() {
        PreviewRenderer.clearCache();
    }

    @Override
    public void resetSoundAt(BlockPos pos) {
        this.currentSounds.remove(pos);
    }

    @Override
    public void setSoundAt(BlockPos pos, SoundEvent currentTune) {
        this.currentSounds.put(pos, PositionedSoundRecord.func_184372_a((SoundEvent)currentTune, (float)pos.func_177958_n(), (float)pos.func_177956_o(), (float)pos.func_177952_p()));
    }

    @Override
    public void stopSoundAt(BlockPos pos) {
        if (this.currentSounds.containsKey(pos)) {
            Minecraft.func_71410_x().func_147118_V().func_147683_b((ISound)this.currentSounds.get(pos));
        }
    }

    @Override
    public boolean hasSoundAt(BlockPos pos) {
        return this.currentSounds.containsKey(pos);
    }

    @Override
    public boolean isSoundPlayingAt(BlockPos pos) {
        if (!this.hasSoundAt(pos)) {
            return false;
        }
        ISound positionedsoundrecord = (ISound)this.currentSounds.get(pos);
        return Minecraft.func_71410_x().func_147118_V().func_147692_c(positionedsoundrecord);
    }

    @Override
    public void playSoundAt(BlockPos pos) {
        if (this.hasSoundAt(pos)) {
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)this.currentSounds.get(pos));
        }
    }

    @Override
    public double getClientPlayerDistanceTo(BlockPos pos) {
        return Minecraft.func_71410_x().field_71439_g.func_70011_f((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5);
    }
}

