/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockChest;
import net.minecraft.block.properties.IProperty;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.gui.GuiLootChestPlacer;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.item.ItemBaseStructure;
import net.shadowmage.ancientwarfare.structure.tile.TileAdvancedLootChest;

public class ItemLootChestPlacer
extends ItemBaseStructure {
    private static final String LOOT_TABLE_NAME_TAG = "lootTableName";
    private static final String LOOT_ROLLS_TAG = "lootRolls";

    public ItemLootChestPlacer() {
        super("loot_chest_placer");
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        if (!player.field_70170_p.field_72995_K) {
            NetworkHandler.INSTANCE.openGui(player, 55, 0, 0, 0);
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            return EnumActionResult.PASS;
        }
        if (world.field_72995_K) {
            return EnumActionResult.SUCCESS;
        }
        ItemStack placer = player.func_184586_b(hand);
        Optional<Tuple<ResourceLocation, Byte>> lt = ItemLootChestPlacer.getLootParameters(placer);
        if (!lt.isPresent() || !this.lootTableExists(world, (ResourceLocation)lt.get().func_76341_a())) {
            return EnumActionResult.PASS;
        }
        BlockPos placePos = pos.func_177972_a(facing);
        if (AWStructureBlocks.ADVANCED_LOOT_CHEST.func_176196_c(world, placePos)) {
            world.func_175656_a(placePos, AWStructureBlocks.ADVANCED_LOOT_CHEST.func_176223_P().func_177226_a((IProperty)BlockChest.field_176459_a, (Comparable)player.func_174811_aO().func_176734_d()));
            WorldTools.getTile((IBlockAccess)world, placePos, TileAdvancedLootChest.class).ifPresent(t -> {
                t.func_189404_a((ResourceLocation)((Tuple)lt.get()).func_76341_a(), new Random(placePos.func_177986_g()).nextLong());
                t.setLootRolls(((Byte)((Tuple)lt.get()).func_76340_b()).byteValue());
            });
            return EnumActionResult.SUCCESS;
        }
        return EnumActionResult.FAIL;
    }

    private boolean lootTableExists(World world, ResourceLocation lootTableName) {
        return world.func_184146_ak().func_186521_a(lootTableName) != null;
    }

    public static Optional<Tuple<ResourceLocation, Byte>> getLootParameters(ItemStack placer) {
        return placer.func_77942_o() && placer.func_77978_p().func_74764_b(LOOT_TABLE_NAME_TAG) ? Optional.of(new Tuple((Object)new ResourceLocation(placer.func_77978_p().func_74779_i(LOOT_TABLE_NAME_TAG)), (Object)placer.func_77978_p().func_74771_c(LOOT_ROLLS_TAG))) : Optional.empty();
    }

    public static void setLootParameters(ItemStack placer, String lootTableName, byte rolls) {
        placer.func_77983_a(LOOT_TABLE_NAME_TAG, (NBTBase)new NBTTagString(lootTableName));
        placer.func_77983_a(LOOT_ROLLS_TAG, (NBTBase)new NBTTagByte(rolls));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        super.registerClient();
        NetworkHandler.registerGui(55, GuiLootChestPlacer.class);
    }
}

