/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.input.InputHandler;
import net.shadowmage.ancientwarfare.core.interfaces.IItemKeyInterface;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.event.IBoxRenderer;
import net.shadowmage.ancientwarfare.structure.gates.types.Gate;
import net.shadowmage.ancientwarfare.structure.item.ItemBaseStructure;

public class ItemGateSpawner
extends ItemBaseStructure
implements IItemKeyInterface,
IBoxRenderer {
    private static final String AW_GATE_INFO_TAG = "AWGateInfo";

    public ItemGateSpawner(String name) {
        super(name);
        this.func_77625_d(1);
        this.func_77627_a(true);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flag) {
        NBTTagCompound tag = stack.func_77942_o() && stack.func_77978_p().func_74764_b(AW_GATE_INFO_TAG) ? stack.func_77978_p().func_74775_l(AW_GATE_INFO_TAG) : new NBTTagCompound();
        if (tag.func_74764_b("pos1") && tag.func_74764_b("pos2")) {
            tooltip.add(I18n.func_135052_a((String)"guistrings.gate.construct", (Object[])new Object[0]));
        } else {
            String key = InputHandler.ALT_ITEM_USE_1.getDisplayName();
            tooltip.add(I18n.func_135052_a((String)"guistrings.gate.use_primary_item_key", (Object[])new Object[]{key}));
        }
        tooltip.add(I18n.func_135052_a((String)"guistrings.gate.clear_item", (Object[])new Object[0]));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        for (int i = 0; i < 16; ++i) {
            Gate g = Gate.getGateByID(i);
            if (g == null) continue;
            items.add((Object)g.getDisplayStack());
        }
    }

    public String func_77667_c(ItemStack par1ItemStack) {
        return "item." + Gate.getGateByID(par1ItemStack.func_77952_i()).getDisplayName();
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
        }
        NBTTagCompound tag = stack.func_77942_o() && stack.func_77978_p().func_74764_b(AW_GATE_INFO_TAG) ? stack.func_77978_p().func_74775_l(AW_GATE_INFO_TAG) : new NBTTagCompound();
        if (player.func_70093_af()) {
            tag = new NBTTagCompound();
            stack.func_77982_d(tag);
        } else if (tag.func_74764_b("pos1") && tag.func_74764_b("pos2")) {
            BlockPos pos1 = BlockPos.func_177969_a((long)tag.func_74763_f("pos1"));
            BlockPos pos2 = BlockPos.func_177969_a((long)tag.func_74763_f("pos2"));
            BlockPos avg = BlockTools.getAverageOf(pos1, pos2);
            int max = 10;
            if (pos1.func_177958_n() - pos2.func_177958_n() > max) {
                max = pos1.func_177958_n() - pos2.func_177958_n();
            } else if (pos2.func_177958_n() - pos1.func_177958_n() > max) {
                max = pos2.func_177958_n() - pos1.func_177958_n();
            }
            if (pos1.func_177952_p() - pos2.func_177952_p() > max) {
                max = pos1.func_177952_p() - pos2.func_177952_p();
            } else if (pos2.func_177952_p() - pos1.func_177952_p() > max) {
                max = pos2.func_177952_p() - pos1.func_177952_p();
            }
            if (player.func_70011_f((double)avg.func_177958_n() + 0.5, (double)pos1.func_177956_o() + 0.5, (double)avg.func_177952_p() + 0.5) > (double)max && player.func_70011_f((double)avg.func_177958_n() + 0.5, (double)pos2.func_177956_o() + 0.5, (double)avg.func_177952_p() + 0.5) > (double)max) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.gate.too_far", new Object[0]));
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            if (!this.canSpawnGate(world, pos1, pos2)) {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.gate.exists", new Object[0]));
                return new ActionResult(EnumActionResult.FAIL, (Object)stack);
            }
            Optional<EntityGate> entity = Gate.constructGate(world, pos1, pos2, Gate.getGateByID(stack.func_77952_i()), player.func_174811_aO(), new Owner(player));
            if (entity.isPresent()) {
                world.func_72838_d((Entity)entity.get());
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                tag.func_82580_o("pos1");
                tag.func_82580_o("pos2");
                stack.func_77982_d(tag);
            } else {
                player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.gate.need_to_clear", new Object[0]));
            }
        }
        return new ActionResult(EnumActionResult.SUCCESS, (Object)stack);
    }

    private boolean canSpawnGate(World world, BlockPos pos1, BlockPos pos2) {
        BlockPos min = BlockTools.getMin(pos1, pos2);
        BlockPos max = BlockTools.getMax(pos1, pos2);
        AxisAlignedBB newGateBB = new AxisAlignedBB((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p(), (double)(max.func_177958_n() + 1), (double)(max.func_177956_o() + 1), (double)(max.func_177952_p() + 1));
        List gates = world.func_72872_a(EntityGate.class, newGateBB);
        for (EntityGate gate : gates) {
            min = BlockTools.getMin(gate.pos1, gate.pos2);
            max = BlockTools.getMax(gate.pos1, gate.pos2);
            AxisAlignedBB oldGateBB = new AxisAlignedBB((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p(), (double)(max.func_177958_n() + 1), (double)(max.func_177956_o() + 1), (double)(max.func_177952_p() + 1));
            if (!oldGateBB.func_72326_a(newGateBB)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean onKeyActionClient(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        return altFunction == IItemKeyInterface.ItemAltFunction.ALT_FUNCTION_1;
    }

    @Override
    public void onKeyAction(EntityPlayer player, ItemStack stack, IItemKeyInterface.ItemAltFunction altFunction) {
        BlockPos hit = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
        if (hit == null) {
            return;
        }
        NBTTagCompound tag = stack.func_77942_o() && stack.func_77978_p().func_74764_b(AW_GATE_INFO_TAG) ? stack.func_77978_p().func_74775_l(AW_GATE_INFO_TAG) : new NBTTagCompound();
        if (!tag.func_74764_b("pos2")) {
            if (tag.func_74764_b("pos1")) {
                Gate g = Gate.getGateByID(stack.func_77952_i());
                if (g.arePointsValidPair(BlockPos.func_177969_a((long)tag.func_74763_f("pos1")), hit)) {
                    tag.func_74772_a("pos2", hit.func_177986_g());
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.gate.set_pos_two", new Object[0]));
                } else {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.gate.invalid_position", new Object[0]));
                }
            } else {
                tag.func_74772_a("pos1", hit.func_177986_g());
                player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.gate.set_pos_one", new Object[0]));
            }
        }
        stack.func_77983_a(AW_GATE_INFO_TAG, (NBTBase)tag);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBox(EntityPlayer player, EnumHand hand, ItemStack stack, float delta) {
        BlockPos p2;
        BlockPos p1;
        NBTTagCompound tag = stack.func_77978_p();
        if (tag != null && tag.func_74764_b(AW_GATE_INFO_TAG)) {
            if ((tag = tag.func_74775_l(AW_GATE_INFO_TAG)).func_74764_b("pos1")) {
                p1 = BlockPos.func_177969_a((long)tag.func_74763_f("pos1"));
                if (tag.func_74764_b("pos2")) {
                    p2 = BlockPos.func_177969_a((long)tag.func_74763_f("pos2"));
                } else {
                    p2 = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
                    if (p2 == null) {
                        return;
                    }
                }
            } else {
                p1 = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
                if (p1 == null) {
                    return;
                }
                p2 = p1;
            }
        } else {
            p1 = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
            if (p1 == null) {
                return;
            }
            p2 = p1;
        }
        IBoxRenderer.Util.renderBoundingBox(player, BlockTools.getMin(p1, p2), BlockTools.getMax(p1, p2), delta);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        ResourceLocation basePath = new ResourceLocation("ancientwarfare", "structure/gate_spawner");
        ModelResourceLocation ironBasic = new ModelResourceLocation(basePath, "variant=gate_iron_basic");
        ModelResourceLocation ironDouble = new ModelResourceLocation(basePath, "variant=gate_iron_double");
        ModelResourceLocation ironSingle = new ModelResourceLocation(basePath, "variant=gate_iron_single");
        ModelResourceLocation woodBasic = new ModelResourceLocation(basePath, "variant=gate_wood_basic");
        ModelResourceLocation woodDouble = new ModelResourceLocation(basePath, "variant=gate_wood_double");
        ModelResourceLocation woodRotating = new ModelResourceLocation(basePath, "variant=gate_wood_rotating");
        ModelResourceLocation woodSingle = new ModelResourceLocation(basePath, "variant=gate_wood_single");
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> {
            switch (Gate.getGateByID(stack.func_77960_j()).getVariant()) {
                case IRON_BASIC: {
                    return ironBasic;
                }
                case IRON_DOUBLE: {
                    return ironDouble;
                }
                case IRON_SINGLE: {
                    return ironSingle;
                }
                case WOOD_BASIC: {
                    return woodBasic;
                }
                case WOOD_DOUBLE: {
                    return woodDouble;
                }
                case WOOD_ROTATING: {
                    return woodRotating;
                }
                case WOOD_SINGLE: {
                    return woodSingle;
                }
            }
            return woodBasic;
        });
        ModelLoader.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{ironBasic, ironDouble, ironSingle, woodBasic, woodDouble, woodRotating, woodSingle});
    }
}

