/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.item.ItemBlockBase;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.event.IBoxRenderer;
import net.shadowmage.ancientwarfare.structure.render.PreviewRenderer;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBB;
import net.shadowmage.ancientwarfare.structure.template.build.StructureBuilderTicked;
import net.shadowmage.ancientwarfare.structure.tile.TileStructureBuilder;

public class ItemBlockStructureBuilder
extends ItemBlockBase
implements IBoxRenderer {
    private static final String STRUCTURE_NAME_TAG = "structureName";

    public ItemBlockStructureBuilder(Block block) {
        super(block);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag flagIn) {
        String name = "corrupt_item";
        if (stack.func_77942_o() && stack.func_77978_p().func_74764_b(STRUCTURE_NAME_TAG)) {
            name = stack.func_77978_p().func_74779_i(STRUCTURE_NAME_TAG);
        }
        tooltip.add(I18n.func_135052_a((String)"guistrings.structure.structure_name", (Object[])new Object[0]) + ": " + name);
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(STRUCTURE_NAME_TAG)) {
            return false;
        }
        boolean val = super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState);
        if (!world.field_72995_K && val) {
            WorldTools.getTile((IBlockAccess)world, pos, TileStructureBuilder.class).ifPresent(t -> this.setupStructureBuilder(stack, player, world, pos, (TileStructureBuilder)t));
        }
        return val;
    }

    private void setupStructureBuilder(ItemStack stack, EntityPlayer player, World world, BlockPos pos, TileStructureBuilder tb) {
        tb.setOwner(player);
        NBTTagCompound tag = stack.func_77978_p();
        String name = tag.func_74779_i(STRUCTURE_NAME_TAG);
        EnumFacing face = player.func_174811_aO();
        this.setupStructureBuilder(world, pos, tb, name, face);
        if (tag.func_74764_b("progress")) {
            StructureBuilderTicked builder = tb.getBuilder();
            builder.deserializeProgressData(tag.func_74775_l("progress"));
        }
    }

    public void setupStructureBuilder(World world, BlockPos pos, TileStructureBuilder tb, String name, EnumFacing face) {
        StructureTemplateManager.getTemplate(name).ifPresent(t -> {
            BlockPos p = pos.func_177967_a(face, t.getSize().func_177952_p() - 1 - t.getOffset().func_177952_p() + 1);
            tb.setBuilder(new StructureBuilderTicked(world, (StructureTemplate)t, face, p));
        });
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderBox(EntityPlayer player, EnumHand hand, ItemStack stack, float delta) {
        if (!stack.func_77942_o() || !stack.func_77978_p().func_74764_b(STRUCTURE_NAME_TAG)) {
            return;
        }
        String name = stack.func_77978_p().func_74779_i(STRUCTURE_NAME_TAG);
        BlockPos hit = BlockTools.getBlockClickedOn(player, player.field_70170_p, true);
        if (hit == null) {
            return;
        }
        StructureTemplateManager.getTemplate(name).ifPresent(t -> {
            IBoxRenderer.Util.renderBoundingBox(player, hit, hit, delta);
            EnumFacing face = player.func_174811_aO();
            BlockPos p2 = hit.func_177967_a(face, t.getSize().func_177952_p() - 1 - t.getOffset().func_177952_p() + 1);
            StructureBB bb = new StructureBB(p2, face, t.getSize(), t.getOffset());
            IBoxRenderer.Util.renderBoundingBox(player, bb.min, bb.max, delta);
            PreviewRenderer.renderTemplatePreview(player, hand, stack, delta, t, bb, (face.func_176736_b() + 2) % 4);
        });
    }
}

