/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.init;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.shadowmage.ancientwarfare.core.util.InjectionTools;
import net.shadowmage.ancientwarfare.structure.block.BlockAdvancedLootChest;
import net.shadowmage.ancientwarfare.structure.block.BlockAdvancedSpawner;
import net.shadowmage.ancientwarfare.structure.block.BlockDraftingStation;
import net.shadowmage.ancientwarfare.structure.block.BlockFirePit;
import net.shadowmage.ancientwarfare.structure.block.BlockGateProxy;
import net.shadowmage.ancientwarfare.structure.block.BlockSoundBlock;
import net.shadowmage.ancientwarfare.structure.block.BlockStructureBuilder;
import net.shadowmage.ancientwarfare.structure.block.BlockStructureScanner;
import net.shadowmage.ancientwarfare.structure.block.BlockTotemPart;
import net.shadowmage.ancientwarfare.structure.item.ItemBlockAdvancedSpawner;
import net.shadowmage.ancientwarfare.structure.item.ItemBlockFirePit;
import net.shadowmage.ancientwarfare.structure.item.ItemBlockStructureBuilder;
import net.shadowmage.ancientwarfare.structure.item.ItemBlockTotemPart;
import net.shadowmage.ancientwarfare.structure.tile.TEGateProxy;
import net.shadowmage.ancientwarfare.structure.tile.TileAdvancedLootChest;
import net.shadowmage.ancientwarfare.structure.tile.TileAdvancedSpawner;
import net.shadowmage.ancientwarfare.structure.tile.TileDraftingStation;
import net.shadowmage.ancientwarfare.structure.tile.TileSoundBlock;
import net.shadowmage.ancientwarfare.structure.tile.TileStructureBuilder;
import net.shadowmage.ancientwarfare.structure.tile.TileStructureScanner;
import net.shadowmage.ancientwarfare.structure.tile.TileTotemPart;

@GameRegistry.ObjectHolder(value="ancientwarfarestructure")
@Mod.EventBusSubscriber(modid="ancientwarfarestructure")
public class AWStructureBlocks {
    public static final Block ADVANCED_SPAWNER = (Block)InjectionTools.nullValue();
    public static final Block GATE_PROXY = (Block)InjectionTools.nullValue();
    public static final Block DRAFTING_STATION = (Block)InjectionTools.nullValue();
    public static final Block STRUCTURE_BUILDER_TICKED = (Block)InjectionTools.nullValue();
    public static final Block SOUND_BLOCK = (Block)InjectionTools.nullValue();
    public static final Block STRUCTURE_SCANNER_BLOCK = (Block)InjectionTools.nullValue();
    public static final Block ADVANCED_LOOT_CHEST = (Block)InjectionTools.nullValue();
    public static final Block FIRE_PIT = (Block)InjectionTools.nullValue();
    public static final Block TOTEM_PART = (Block)InjectionTools.nullValue();

    private AWStructureBlocks() {
    }

    @SubscribeEvent
    public static void registerItemBlocks(RegistryEvent.Register<Item> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new ItemBlockAdvancedSpawner(ADVANCED_SPAWNER));
        registry.register(new ItemBlock(GATE_PROXY).setRegistryName(GATE_PROXY.getRegistryName()));
        registry.register(new ItemBlock(DRAFTING_STATION).setRegistryName(DRAFTING_STATION.getRegistryName()));
        registry.register((IForgeRegistryEntry)new ItemBlockStructureBuilder(STRUCTURE_BUILDER_TICKED));
        registry.register(new ItemBlock(SOUND_BLOCK).setRegistryName(SOUND_BLOCK.getRegistryName()));
        registry.register(new ItemBlock(STRUCTURE_SCANNER_BLOCK).setRegistryName(STRUCTURE_SCANNER_BLOCK.getRegistryName()));
        registry.register(new ItemBlock(ADVANCED_LOOT_CHEST).setRegistryName(ADVANCED_LOOT_CHEST.getRegistryName()));
        registry.register((IForgeRegistryEntry)new ItemBlockFirePit(FIRE_PIT));
        registry.register((IForgeRegistryEntry)new ItemBlockTotemPart(TOTEM_PART));
    }

    @SubscribeEvent
    public static void register(RegistryEvent.Register<Block> event) {
        IForgeRegistry registry = event.getRegistry();
        registry.register((IForgeRegistryEntry)new BlockAdvancedSpawner());
        AWStructureBlocks.registerTile(TileAdvancedSpawner.class, "advanced_spawner_tile");
        registry.register((IForgeRegistryEntry)new BlockGateProxy());
        AWStructureBlocks.registerTile(TEGateProxy.class, "gate_proxy_tile");
        registry.register((IForgeRegistryEntry)new BlockDraftingStation());
        AWStructureBlocks.registerTile(TileDraftingStation.class, "drafting_station_tile");
        registry.register((IForgeRegistryEntry)new BlockStructureBuilder());
        AWStructureBlocks.registerTile(TileStructureBuilder.class, "structure_builder_ticked_tile");
        registry.register((IForgeRegistryEntry)new BlockSoundBlock());
        AWStructureBlocks.registerTile(TileSoundBlock.class, "sound_block_tile");
        registry.register((IForgeRegistryEntry)new BlockStructureScanner());
        AWStructureBlocks.registerTile(TileStructureScanner.class, "structure_scanner_block_tile");
        registry.register((IForgeRegistryEntry)new BlockAdvancedLootChest());
        AWStructureBlocks.registerTile(TileAdvancedLootChest.class, "advanced_loot_chest_tile");
        registry.register((IForgeRegistryEntry)new BlockTotemPart());
        AWStructureBlocks.registerTile(TileTotemPart.class, "totem_part_tile");
        registry.register((IForgeRegistryEntry)new BlockFirePit());
    }

    private static void registerTile(Class<? extends TileEntity> teClass, String teId) {
        GameRegistry.registerTileEntity(teClass, (ResourceLocation)new ResourceLocation("ancientwarfarestructure", teId));
    }
}

