/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.Comparator;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.structure.container.ContainerStructureSelectionBase;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;

public class GuiStructureSelectionBase
extends GuiContainerBase<ContainerStructureSelectionBase>
implements StructureTemplateManager.ITemplateObserver {
    private Text filterInput;
    private StructureTemplate currentSelection;
    private CompositeScrolled selectionArea;
    private Label selection;
    private CompositeScrolled resourceArea;

    public GuiStructureSelectionBase(ContainerBase par1Container) {
        super(par1Container, 400, 240);
        StructureTemplateManager.registerObserver(this);
    }

    public void func_146281_b() {
        StructureTemplateManager.unregisterObserver(this);
    }

    @Override
    public void initElements() {
        this.addGuiElement(new Button(this.field_146999_f - 55 - 8, 8, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                if (GuiStructureSelectionBase.this.currentSelection != null) {
                    ((ContainerStructureSelectionBase)((Object)GuiStructureSelectionBase.this.getContainer())).handleNameSelection(((GuiStructureSelectionBase)GuiStructureSelectionBase.this).currentSelection.name);
                    ((ContainerStructureSelectionBase)((Object)GuiStructureSelectionBase.this.getContainer())).addSlots();
                    GuiStructureSelectionBase.this.closeGui();
                }
            }
        });
        Label label = new Label(8, 8, "guistrings.current_selection");
        this.addGuiElement(label);
        this.selection = new Label(8, 20, "");
        this.addGuiElement(this.selection);
        this.filterInput = new Text(8, 30, 224, "", this){

            @Override
            protected void handleKeyInput(int keyCode, char ch) {
                super.handleKeyInput(keyCode, ch);
                GuiStructureSelectionBase.this.refreshGui();
            }
        };
        this.addGuiElement(this.filterInput);
        this.selectionArea = new CompositeScrolled(this, 0, 50, 256, 190);
        this.addGuiElement(this.selectionArea);
        this.resourceArea = new CompositeScrolled(this, 256, 40, 144, 200);
        this.addGuiElement(this.resourceArea);
        this.setSelection(((ContainerStructureSelectionBase)((Object)this.getContainer())).structureName);
    }

    @Override
    public void setupElements() {
        this.selectionArea.clearElements();
        int totalHeight = 8;
        for (String templateName2 : this.getTemplatesForDisplay().stream().filter(templateName -> templateName.toLowerCase().contains(this.filterInput.getText().toLowerCase())).sorted(Comparator.comparing(String::toLowerCase)).collect(Collectors.toList())) {
            TemplateButton button = new TemplateButton(8, totalHeight, templateName2);
            this.selectionArea.addGuiElement(button);
            totalHeight += 12;
        }
        this.selectionArea.setAreaSize(totalHeight + 8);
    }

    protected Set<String> getTemplatesForDisplay() {
        return StructureTemplateManager.getTemplates();
    }

    @Override
    public void notifyTemplateChange(StructureTemplate template) {
        if (template.name.equals(this.selection.getText())) {
            this.currentSelection = template;
            this.updateSurivalResources();
        }
    }

    private void setSelection(String templateName) {
        this.setSelectionName(templateName);
        this.currentSelection = StructureTemplateManager.getTemplate(templateName).orElse(null);
        this.updateSurivalResources();
    }

    private void updateSurivalResources() {
        this.resourceArea.clearElements();
        int totalHeight = 8;
        if (this.currentSelection != null && this.currentSelection.getValidationSettings().isSurvival()) {
            for (ItemStack stack : this.currentSelection.getResourceList()) {
                ItemSlot item = new ItemSlot(8, totalHeight, stack, this);
                this.resourceArea.addGuiElement(item);
                totalHeight += 18;
            }
        }
        this.resourceArea.setAreaSize(totalHeight + 8);
    }

    private void setSelectionName(String name) {
        this.selection.setText(name);
    }

    private class TemplateButton
    extends Button {
        private String templateName;

        private TemplateButton(int topLeftX, int topLeftY, String templateName) {
            super(topLeftX, topLeftY, 232, 12, templateName);
            this.templateName = templateName;
        }

        @Override
        protected void onPressed() {
            GuiStructureSelectionBase.this.setSelection(this.templateName);
        }
    }
}

