/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.io.File;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.structure.container.ContainerStructureScanner;
import net.shadowmage.ancientwarfare.structure.gui.GuiDimensionSelection;
import net.shadowmage.ancientwarfare.structure.gui.GuiModSelection;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureBiomeSelection;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureIncorrectName;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureValidationSettings;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplateManager;

public class GuiStructureScanner
extends GuiContainerBase<ContainerStructureScanner>
implements IContainerListener {
    private Text nameInput;
    private Label validationTypeLabel;
    private Button exportButton;
    private Checkbox includeImmediately;
    private Button setupValidationButton;
    private Button selectBiomesButton;
    private Button selectDimensionsButton;
    private Button selectModsButton;
    private Label statusMessage;
    private int statusTicks = 0;
    private Button boundsButton;
    private Button restoreButton;

    public GuiStructureScanner(ContainerBase par1Container) {
        super(par1Container);
        par1Container.func_75132_a(this);
    }

    @Override
    public void initElements() {
        int totalHeight = 8;
        this.statusMessage = new Label(80, 10, "");
        this.addGuiElement(this.statusMessage);
        if (((ContainerStructureScanner)((Object)this.getContainer())).getScannerTile().isPresent()) {
            totalHeight += 20;
        }
        Label label = new Label(8, totalHeight, I18n.func_135052_a((String)"guistrings.input_name", (Object[])new Object[0]) + ":");
        this.addGuiElement(label);
        this.nameInput = new Text(8, totalHeight += 12, 160, ((ContainerStructureScanner)((Object)this.getContainer())).getName(), this){

            @Override
            public void onTextUpdated(String oldText, String newText) {
                if (!oldText.equals(newText)) {
                    ((ContainerStructureScanner)((Object)GuiStructureScanner.this.getContainer())).updateName(newText);
                }
            }
        };
        this.nameInput.removeAllowedChars('/', '\\', '$', '!', '@', '#', '$', '%', '^', '&', '*', '(', ')', ':', ';', '\"', '\'', '+', '=', '<', '>', '?', '.', ',', '[', ']', '{', '}', '|');
        this.addGuiElement(this.nameInput);
        this.includeImmediately = new Checkbox(8, totalHeight += 12, 16, 16, "guistrings.include_immediately"){

            @Override
            public void onToggled() {
                ((ContainerStructureScanner)((Object)GuiStructureScanner.this.getContainer())).setIncludeImmediately(this.checked());
            }
        };
        this.addGuiElement(this.includeImmediately);
        this.validationTypeLabel = new Label(8, totalHeight += 24, I18n.func_135052_a((String)"guistrings.validation_type", (Object[])new Object[0]) + " " + ((ContainerStructureScanner)((Object)this.getContainer())).getValidationTypeName());
        this.addGuiElement(this.validationTypeLabel);
        this.setupValidationButton = new Button(8, totalHeight += 10, 120, 16, "guistrings.setup_validation"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiStructureValidationSettings(GuiStructureScanner.this));
            }
        };
        this.addGuiElement(this.setupValidationButton);
        this.selectBiomesButton = new Button(8, totalHeight += 16, 120, 16, "guistrings.select_biomes"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiStructureBiomeSelection(GuiStructureScanner.this));
            }
        };
        this.addGuiElement(this.selectBiomesButton);
        this.selectDimensionsButton = new Button(8, totalHeight += 16, 120, 16, "guistrings.select_dimensions"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiDimensionSelection(GuiStructureScanner.this));
            }
        };
        this.addGuiElement(this.selectDimensionsButton);
        this.selectModsButton = new Button(8, totalHeight += 16, 120, 16, "guistrings.select_mods"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiModSelection(GuiStructureScanner.this));
            }
        };
        this.addGuiElement(this.selectModsButton);
        this.addButtons();
        this.updateElements();
    }

    private void addButtons() {
        int totalHeight = 8;
        this.exportButton = new Button(193, totalHeight, 55, 16, "guistrings.export");
        this.exportButton.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    GuiStructureScanner.this.export();
                }
                return true;
            }
        });
        this.addGuiElement(this.exportButton);
        this.boundsButton = new Button(183, -20, 65, 16, ((ContainerStructureScanner)((Object)this.getContainer())).getBoundsActive() ? "guistrings.bounds_off" : "guistrings.bounds_on");
        this.boundsButton.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    GuiStructureScanner.this.toggleBounds();
                }
                return true;
            }
        });
        this.addGuiElement(this.boundsButton);
        this.restoreButton = new Button(193, totalHeight += 20, 55, 16, "guistrings.restore");
        this.restoreButton.addNewListener(new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (widget.isMouseOverElement(evt.mx, evt.my)) {
                    GuiStructureScanner.this.restore();
                }
                return true;
            }
        });
        this.addGuiElement(this.restoreButton);
    }

    private void toggleBounds() {
        ((ContainerStructureScanner)((Object)this.getContainer())).toggleBounds();
        this.boundsButton.setText(((ContainerStructureScanner)((Object)this.getContainer())).getBoundsActive() ? "guistrings.bounds_off" : "guistrings.bounds_on");
    }

    private void updateElements() {
        if (this.exportButton == null) {
            return;
        }
        boolean hasScanner = ((ContainerStructureScanner)((Object)this.getContainer())).hasScanner();
        boolean readyToExport = ((ContainerStructureScanner)((Object)this.getContainer())).getReadyToExport();
        this.exportButton.setEnabled(readyToExport);
        this.boundsButton.setEnabled(readyToExport);
        this.restoreButton.setEnabled(hasScanner);
        this.nameInput.setText(((ContainerStructureScanner)((Object)this.getContainer())).getName());
        this.nameInput.setEnabled(hasScanner);
        this.includeImmediately.setChecked(((ContainerStructureScanner)((Object)this.getContainer())).getIncludeImmediately());
        this.includeImmediately.setEnabled(readyToExport);
        this.setupValidationButton.setEnabled(readyToExport);
        this.selectBiomesButton.setEnabled(readyToExport);
        this.selectDimensionsButton.setEnabled(readyToExport);
        this.selectModsButton.setEnabled(readyToExport);
    }

    @Override
    public void setupElements() {
        if (!((ContainerStructureScanner)((Object)this.getContainer())).hasScanner()) {
            return;
        }
        this.validationTypeLabel.setText(I18n.func_135052_a((String)"guistrings.validation_type", (Object[])new Object[0]) + " " + ((ContainerStructureScanner)((Object)this.getContainer())).getValidationTypeName());
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (this.statusTicks > 0) {
            --this.statusTicks;
        }
        this.statusMessage.setVisible(this.statusTicks > 0);
    }

    private void export() {
        String name = this.nameInput.getText();
        if (!this.validateName(name)) {
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiStructureIncorrectName(this));
        } else {
            ((ContainerStructureScanner)((Object)this.getContainer())).export();
            if (!((ContainerStructureScanner)((Object)this.getContainer())).getScannerTile().isPresent()) {
                this.closeGui();
            } else {
                this.statusMessage.setText("Exported");
                this.statusTicks = 60;
            }
        }
    }

    private void restore() {
        String name = this.nameInput.getText();
        if (StructureTemplateManager.templateExists(name)) {
            ((ContainerStructureScanner)((Object)this.getContainer())).restoreTemplate(name);
        } else {
            this.statusMessage.setText("Template Name doesn't exist");
            this.statusTicks = 60;
        }
    }

    private boolean validateName(String name) {
        if (name.equals("")) {
            return false;
        }
        for (int i = 0; i < name.length(); ++i) {
            if (this.validateChar(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private boolean validateChar(char ch) {
        return ch != File.separatorChar;
    }

    public void func_71110_a(Container containerToSend, NonNullList<ItemStack> itemsList) {
    }

    public void func_71111_a(Container containerToSend, int slotInd, ItemStack stack) {
        if (slotInd == 0) {
            this.updateElements();
        }
    }

    public void func_71112_a(Container containerIn, int varToUpdate, int newValue) {
    }

    public void func_175173_a(Container containerIn, IInventory inventory) {
    }
}

