/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.Iterator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.core.util.SongPlayData;

public class GuiSoundSelect
extends GuiContainerBase {
    private final GuiContainerBase parent;
    private final SongPlayData.SongEntry songEntry;
    private CompositeScrolled area;
    private Text selectionLabel;

    protected GuiSoundSelect(GuiContainerBase parent, SongPlayData.SongEntry entry) {
        super((ContainerBase)((Object)parent.getContainer()));
        this.parent = parent;
        this.songEntry = entry;
    }

    @Override
    public void initElements() {
        Button button = new Button(193, 8, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)GuiSoundSelect.this.parent);
                GuiSoundSelect.this.parent.refreshGui();
            }
        };
        this.addGuiElement(button);
        this.selectionLabel = new Text(8, 30, 240, this.songEntry.name(), this){

            @Override
            protected void handleKeyInput(int keyCode, char ch) {
                String old = this.getText();
                super.handleKeyInput(keyCode, ch);
                String text = this.getText();
                if (!text.equals(old)) {
                    GuiSoundSelect.this.refreshGui();
                }
            }
        };
        Listener l = new Listener(4){

            @Override
            public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                if (evt.mButton == 1 && widget.isMouseOverElement(evt.mx, evt.my)) {
                    ((Text)widget).setText("");
                    GuiSoundSelect.this.refreshGui();
                }
                return false;
            }
        };
        this.selectionLabel.addNewListener(l);
        this.addGuiElement(this.selectionLabel);
        this.area = new CompositeScrolled(this, 0, 40, 256, 200);
        this.addGuiElement(this.area);
    }

    @Override
    public void setupElements() {
        Iterator itr;
        this.area.clearElements();
        try {
            itr = ForgeRegistries.SOUND_EVENTS.getKeys().stream().filter(input -> input.toString().contains(this.selectionLabel.getText())).iterator();
        }
        catch (Exception e) {
            return;
        }
        int totalHeight = 8;
        while (itr.hasNext()) {
            final ResourceLocation regisryName = (ResourceLocation)itr.next();
            final String name = regisryName.toString();
            Button button = new Button(8, totalHeight, 232, 12, name){

                @Override
                protected void onPressed() {
                    GuiSoundSelect.this.songEntry.setSound((SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(regisryName));
                    GuiSoundSelect.this.selectionLabel.setText(name);
                    GuiSoundSelect.this.refreshGui();
                }
            };
            this.area.addGuiElement(button);
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        return false;
    }
}

