/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.structure.container.ContainerStructureScanner;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureScanner;

public class GuiModSelection
extends GuiContainerBase {
    private final GuiStructureScanner parent;
    private CompositeScrolled area;
    private Text modEntry;
    private Set<String> mods = new HashSet<String>();

    public GuiModSelection(GuiStructureScanner parent) {
        super(new ContainerBase(((ContainerStructureScanner)((Object)parent.getContainer())).player));
        this.parent = parent;
        this.shouldCloseOnVanillaKeys = false;
        this.mods.addAll(((ContainerStructureScanner)((Object)parent.getContainer())).getModDependencies());
    }

    @Override
    public void initElements() {
        Label label = new Label(8, 8, I18n.func_135052_a((String)"guistrings.select_mods", (Object[])new Object[0]) + ":");
        this.addGuiElement(label);
        this.area = new CompositeScrolled(this, 0, 40, 256, 200);
        this.addGuiElement(this.area);
        Button button = new Button(193, 8, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                GuiModSelection.this.closeGui();
            }
        };
        this.addGuiElement(button);
        this.modEntry = new Text(8, 22, 167, "", this);
        button = new Button(179, 22, 12, 12, "+"){

            @Override
            protected void onPressed() {
                if (!GuiModSelection.this.modEntry.getText().isEmpty()) {
                    GuiModSelection.this.mods.add(GuiModSelection.this.modEntry.getText());
                    ((ContainerStructureScanner)((Object)GuiModSelection.this.parent.getContainer())).updateModDependencies(GuiModSelection.this.mods);
                    GuiModSelection.this.refreshGui();
                }
            }
        };
        this.addGuiElement(button);
        this.addGuiElement(this.modEntry);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        int totalHeight = 8;
        for (String mod : this.mods) {
            this.area.addGuiElement(new ModButton(8, totalHeight, 232, 12, mod));
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        return false;
    }

    private class ModButton
    extends Button {
        final String mod;

        public ModButton(int topLeftX, int topLeftY, int width, int height, String mod) {
            super(topLeftX, topLeftY, width, height, mod);
            this.mod = mod;
        }

        @Override
        protected void onPressed() {
            GuiModSelection.this.mods.remove(this.mod);
            ((ContainerStructureScanner)((Object)GuiModSelection.this.parent.getContainer())).updateModDependencies(GuiModSelection.this.mods);
            GuiModSelection.this.refreshGui();
        }
    }
}

