/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.Comparator;
import java.util.stream.Collectors;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.Listener;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.structure.container.ContainerLootChestPlacer;

public class GuiLootChestPlacer
extends GuiContainerBase<ContainerLootChestPlacer> {
    private static final int TOP_HEIGHT = 42;
    private static final int FORM_WIDTH = 300;
    private static final int FORM_HEIGHT = 200;
    private CompositeScrolled selectionArea;
    private Label selection;
    private Text filterInput;
    private NumberInput lootRolls;

    public GuiLootChestPlacer(ContainerBase container) {
        super(container, 300, 200);
    }

    @Override
    public void initElements() {
        this.addGuiElement(new Label(8, 8, "guistrings.current_selection"));
        this.addGuiElement(new Label(180, 8, "guistrings.loot_rolls"));
        this.selection = new Label(8, 20, this.getSelectedLootTable());
        this.addGuiElement(this.selection);
        this.lootRolls = new NumberInput(240, 6, 15, this.getLootRolls().byteValue(), this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerLootChestPlacer)((Object)GuiLootChestPlacer.this.getContainer())).setLootParameters(GuiLootChestPlacer.this.selection.getText(), (byte)this.getIntegerValue());
            }
        };
        this.lootRolls.setIntegerValue();
        this.addGuiElement(this.lootRolls);
        this.filterInput = new Text(8, 30, 284, "", this){

            @Override
            protected void handleKeyInput(int keyCode, char ch) {
                super.handleKeyInput(keyCode, ch);
                GuiLootChestPlacer.this.refreshGui();
            }
        };
        this.addGuiElement(this.filterInput);
        this.selectionArea = new CompositeScrolled(this, 0, 42, 300, 158);
        this.addGuiElement(this.selectionArea);
    }

    private String getSelectedLootTable() {
        return ((ContainerLootChestPlacer)((Object)this.getContainer())).getLootParameters().map(t -> ((ResourceLocation)t.func_76341_a()).toString()).orElse("guistrings.none");
    }

    private Byte getLootRolls() {
        return ((ContainerLootChestPlacer)((Object)this.getContainer())).getLootParameters().map(Tuple::func_76340_b).orElse((byte)0);
    }

    @Override
    public void setupElements() {
        int totalHeight = 8;
        this.selectionArea.clearElements();
        for (final String lootTableName : ((ContainerLootChestPlacer)((Object)this.getContainer())).getLootTableNames().stream().filter(lt -> lt.toLowerCase().contains(this.filterInput.getText().toLowerCase())).sorted(Comparator.naturalOrder()).collect(Collectors.toList())) {
            Button button = new Button(8, totalHeight, 272, 12, lootTableName);
            button.addNewListener(new Listener(4){

                @Override
                public boolean onEvent(GuiElement widget, GuiContainerBase.ActivationEvent evt) {
                    if (evt.mButton == 0 && widget.isMouseOverElement(evt.mx, evt.my)) {
                        GuiLootChestPlacer.this.selection.setText(lootTableName);
                        ((ContainerLootChestPlacer)((Object)GuiLootChestPlacer.this.getContainer())).setLootParameters(lootTableName, (byte)GuiLootChestPlacer.this.lootRolls.getIntegerValue());
                    }
                    return true;
                }
            });
            totalHeight += 12;
            this.selectionArea.addGuiElement(button);
        }
        this.selectionArea.setAreaSize(totalHeight + 8);
    }
}

