/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.container.ContainerSpawnerAdvancedBase;
import net.shadowmage.ancientwarfare.structure.tile.TileAdvancedSpawner;

public class ContainerSpawnerAdvancedBlock
extends ContainerSpawnerAdvancedBase {
    private static final String SPAWNER_SETTINGS_TAG = "spawnerSettings";
    private final TileAdvancedSpawner spawner;

    public ContainerSpawnerAdvancedBlock(EntityPlayer player, int x, int y, int z) {
        super(player);
        Optional<TileAdvancedSpawner> te = WorldTools.getTile((IBlockAccess)player.field_70170_p, new BlockPos(x, y, z), TileAdvancedSpawner.class);
        if (!te.isPresent()) {
            throw new IllegalArgumentException("Spawner not found");
        }
        this.spawner = te.get();
        this.settings = this.spawner.getSettings();
    }

    @Override
    public void sendInitData() {
        if (!this.spawner.func_145831_w().field_72995_K) {
            NetworkHandler.sendToPlayer((EntityPlayerMP)this.player, this.getSettingPacket());
        }
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b(SPAWNER_SETTINGS_TAG)) {
            if (this.spawner.func_145831_w().field_72995_K) {
                this.settings.readFromNBT(tag.func_74775_l(SPAWNER_SETTINGS_TAG));
                this.refreshGui();
            } else {
                this.spawner.getSettings().readFromNBT(tag.func_74775_l(SPAWNER_SETTINGS_TAG));
                this.spawner.func_70296_d();
                BlockTools.notifyBlockUpdate(this.spawner);
            }
        }
    }
}

