/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.container.ContainerTileBase;
import net.shadowmage.ancientwarfare.core.util.SongPlayData;
import net.shadowmage.ancientwarfare.structure.tile.TileSoundBlock;

public class ContainerSoundBlock
extends ContainerTileBase<TileSoundBlock> {
    private static final String TUNE_DATA_TAG = "tuneData";
    private static final String RANGE_TAG = "range";
    public SongPlayData data;
    public int range;

    public ContainerSoundBlock(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        this.data = ((TileSoundBlock)this.tileEntity).getSongs();
        this.range = ((TileSoundBlock)this.tileEntity).getPlayerRange();
    }

    @Override
    public void sendInitData() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74782_a(TUNE_DATA_TAG, (NBTBase)this.data.writeToNBT(new NBTTagCompound()));
        tag.func_74768_a(RANGE_TAG, this.range);
        this.sendDataToClient(tag);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b(TUNE_DATA_TAG)) {
            ((TileSoundBlock)this.tileEntity).getSongs().readFromNBT(tag.func_74775_l(TUNE_DATA_TAG));
            this.data = ((TileSoundBlock)this.tileEntity).getSongs();
        }
        this.range = tag.func_74762_e(RANGE_TAG);
        ((TileSoundBlock)this.tileEntity).setPlayerRange(this.range);
        if (!((TileSoundBlock)this.tileEntity).func_145831_w().field_72995_K) {
            ((TileSoundBlock)this.tileEntity).func_70296_d();
        }
        this.refreshGui();
    }

    public void sendTuneDataToServer(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74782_a(TUNE_DATA_TAG, (NBTBase)this.data.writeToNBT(new NBTTagCompound()));
            tag.func_74768_a(RANGE_TAG, this.range);
            this.sendDataToServer(tag);
        }
    }
}

