/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.storage.loot.LootTableList;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.item.ItemLootChestPlacer;

public class ContainerLootChestPlacer
extends ContainerBase {
    private final ItemStack placer;

    public ContainerLootChestPlacer(EntityPlayer player, int x, int y, int z) {
        super(player);
        this.placer = EntityTools.getItemFromEitherHand(player, ItemLootChestPlacer.class);
    }

    public List<String> getLootTableNames() {
        return LootTableList.func_186374_a().stream().map(ResourceLocation::toString).filter(rl -> !AWStructureStatics.lootTableExclusions.contains(rl)).collect(Collectors.toList());
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        this.setLootParameters(tag.func_74779_i("setTable"), tag.func_74771_c("rolls"));
    }

    public void setLootParameters(String lootTableName, byte rolls) {
        if (this.player.field_70170_p.field_72995_K) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74778_a("setTable", lootTableName);
            tag.func_74774_a("rolls", rolls);
            this.sendDataToServer(tag);
            return;
        }
        ItemLootChestPlacer.setLootParameters(this.placer, lootTableName, rolls);
    }

    public Optional<Tuple<ResourceLocation, Byte>> getLootParameters() {
        return ItemLootChestPlacer.getLootParameters(this.placer);
    }

    public void setLootTable(String lootTableName) {
    }
}

